/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.MessageLog;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceLoader {
    private ResourceBundle m_bundle = null;

    public ResourceLoader() {
        ResourceLoader.setOpNavLocale();
    }

    public void setResourceName(String string) {
        if (this.m_bundle == null) {
            try {
                this.m_bundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                MessageLog.printStackTrace((Throwable)missingResourceException);
            }
        }
    }

    public String getString(String string) {
        if (this.m_bundle != null) {
            String string2;
            try {
                string2 = this.m_bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                Object[] objectArray = new Object[]{string};
                MessageLog.traceErr((Object)SystemResourceFinder.format((String)"resourceKeyNotFound", (Object[])objectArray));
                string2 = "RESOURCEMISSING";
            }
            return string2;
        }
        return "RESOURCEBUNDLEERROR";
    }

    public static void setOpNavLocale() {
        if (Locale.getDefault().getLanguage().equals("nb")) {
            Locale.setDefault(new Locale("no"));
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

