/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.PanelGroupHelpIdentifier;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClHelpId;
import com.ibm.as400.ui.util.ClLayoutPanel;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.MessageViewer;
import com.ibm.as400.util.CommandHelpRetriever;
import java.awt.Container;
import java.util.Hashtable;

class ClHelp {
    private static String m_help;
    private static String m_startingAnchor;
    private static ClHelpId[] m_helpIds;
    private Hashtable m_hash;
    private ClLayoutPanel m_panel;
    private String m_prdLib;

    ClHelp(ClLayoutPanel clLayoutPanel, String string) {
        m_help = "";
        m_helpIds = null;
        this.m_panel = clLayoutPanel;
        this.m_hash = new Hashtable();
        this.m_prdLib = string;
    }

    void load() {
        AS400 aS400 = ClPanel.m_system;
        m_startingAnchor = null;
        String string = this.m_panel.getCmd();
        String string2 = this.m_panel.getCmdLib();
        if (string2 == null || string2.equalsIgnoreCase("__LIBL")) {
            string2 = "*LIBL";
        }
        try {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string2, string, "CMD");
            Command command = new Command(aS400, qSYSObjectPathName.getPath());
            CommandHelpRetriever commandHelpRetriever = new CommandHelpRetriever();
            commandHelpRetriever.setShowChoiceProgramValues(true);
            m_help = commandHelpRetriever.generateHTML(command);
            PanelGroupHelpIdentifier[] panelGroupHelpIdentifierArray = command.getXMLHelpIdentifiers();
            if (panelGroupHelpIdentifierArray == null) {
                return;
            }
            String[] stringArray = new String[panelGroupHelpIdentifierArray.length];
            for (int i = 0; i < panelGroupHelpIdentifierArray.length; ++i) {
                int n;
                String string3 = panelGroupHelpIdentifierArray[i].getName();
                String string4 = panelGroupHelpIdentifierArray[i].getAnchor();
                int n2 = string3.indexOf(string + "/");
                if (n2 != -1) {
                    string3 = string3.substring(string.length() + 1);
                }
                if ((n = string3.indexOf(47)) != -1) {
                    string3 = string3.substring(n + 1, string3.length());
                }
                this.m_hash.put(string3, string4);
                stringArray[i] = panelGroupHelpIdentifierArray[i].getAnchor();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClassNotFoundException || throwable instanceof NoClassDefFoundError) {
                MessageLog.logError((Object)"CommandHelpRetriever call failed since xalan or other xslt processor is not available.  Making a direct server api call instead.");
            } else {
                MessageLog.printStackTrace((Throwable)throwable);
                MessageLog.logError((Object)("CommandHelpRetriever call failed due to \"" + throwable.getClass().getName() + "\".  Making a direct server api call instead."));
            }
            this.oldLoad();
        }
    }

    void oldLoad() {
        if (m_helpIds == null) {
            return;
        }
        boolean bl = false;
        if (this.m_prdLib != null && !this.m_prdLib.equals("")) {
            bl = ClPanel.addToLibraryList(this.m_prdLib);
        }
        this.m_hash.clear();
        boolean bl2 = false;
        int[] nArray = new int[1];
        byte[] byArray = new byte[4];
        AS400 aS400 = ClPanel.m_system;
        try {
            String string;
            int n;
            MessageLog.logError((Object)"CP: Beginning PCML Call..");
            MessageLog.logError((Object)"CP:    Constructing ProgramCallDocument for QUHRHLPT API...");
            ProgramCallDocument programCallDocument = new ProgramCallDocument(aS400, "com.ibm.as400.ui.util.quhrhlpt");
            programCallDocument.setIntValue("quhrhlpt.nbrHlpIds", m_helpIds.length);
            if (m_helpIds.length == 0) {
                if (bl) {
                    ClPanel.removeFromLibraryList(this.m_prdLib);
                }
                return;
            }
            int[] nArray2 = new int[]{0};
            for (n = 0; n < m_helpIds.length; ++n) {
                nArray2[0] = n;
                programCallDocument.setValue("quhrhlpt.idsToReturn.hlpIdName", nArray2, (Object)m_helpIds[n].getName());
                programCallDocument.setValue("quhrhlpt.idsToReturn.objName", nArray2, (Object)m_helpIds[n].getObjectName());
                programCallDocument.setValue("quhrhlpt.idsToReturn.objLibName", nArray2, (Object)m_helpIds[n].getLibraryName());
            }
            programCallDocument.setIntValue("quhrhlpt.receiverLength", 32 + 192 * m_helpIds.length);
            MessageLog.logError((Object)"CP:    Calling QUHRHLPT API.");
            bl2 = programCallDocument.callProgram("quhrhlpt");
            if (!bl2) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("quhrhlpt");
                PanelManager panelManager = null;
                try {
                    panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", "ADVANCED_BUTTON_PANEL", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string2 = ClPanel.loadString("IDS_MESSAGE_ERROR");
                MessageViewer messageViewer = new MessageViewer(string2, panelManager);
                messageViewer.setSystem(ClPanel.m_system);
                messageViewer.addMessages(aS400MessageArray);
                messageViewer.setVisible(true);
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    String string3 = aS400MessageArray[i].getID();
                    String string4 = aS400MessageArray[i].getText();
                    MessageLog.logError((Object)("CP:    " + string3 + " - " + string4));
                }
                MessageLog.logError((Object)"CP: ** Call to Quhrhlpt failed. See messages above **");
                if (bl) {
                    ClPanel.removeFromLibraryList(this.m_prdLib);
                }
                return;
            }
            n = (Integer)programCallDocument.getValue("quhrhlpt.receiver.bytesRtn", new int[]{0});
            int n2 = (Integer)programCallDocument.getValue("quhrhlpt.receiver.bytesAvail", new int[]{0});
            int n3 = (Integer)programCallDocument.getValue("quhrhlpt.document.bytesReturned", new int[]{0});
            int n4 = (Integer)programCallDocument.getValue("quhrhlpt.document.bytesAvailable", new int[]{0});
            MessageLog.logError((Object)("CP: Bytes returned: " + n));
            MessageLog.logError((Object)("CP: Bytes available: " + n2));
            MessageLog.logError((Object)("CP: Format Name: " + programCallDocument.getValue("quhrhlpt.receiver.fmtName", new int[]{0})));
            MessageLog.logError((Object)("CP: Number entries: " + programCallDocument.getValue("quhrhlpt.receiver.nbrEntries", new int[]{0})));
            MessageLog.logError((Object)("CP: Help Bytes returned: " + programCallDocument.getValue("quhrhlpt.document.bytesReturned")));
            if (n < n2 || n3 < n4) {
                programCallDocument.setIntValue("quhrhlpt.documentSize", n4);
                programCallDocument.setIntValue("quhrhlpt.receiverLength", n2);
                MessageLog.logError((Object)"CP:    Calling QUHRHLPT API Second Time.");
                bl2 = programCallDocument.callProgram("quhrhlpt");
                if (!bl2) {
                    AS400Message[] aS400MessageArray = programCallDocument.getMessageList("quhrhlpt");
                    PanelManager panelManager = null;
                    try {
                        panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", "ADVANCED_BUTTON_PANEL", null, (Container)this.m_panel);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string5 = ClPanel.loadString("IDS_MESSAGE_ERROR");
                    MessageViewer messageViewer = new MessageViewer(string5, panelManager);
                    messageViewer.setSystem(ClPanel.m_system);
                    messageViewer.addMessages(aS400MessageArray);
                    messageViewer.setVisible(true);
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        String string6 = aS400MessageArray[i].getID();
                        String string7 = aS400MessageArray[i].getText();
                        MessageLog.logError((Object)("CP:    " + string6 + " - " + string7));
                    }
                    MessageLog.logError((Object)"CP: ** Call to Quhrhlpt failed. See messages above **");
                    if (bl) {
                        ClPanel.removeFromLibraryList(this.m_prdLib);
                    }
                    return;
                }
            }
            int n5 = (Integer)programCallDocument.getValue("quhrhlpt.receiver.nbrEntries", new int[]{0});
            for (int i = 0; i < n5; ++i) {
                int n6;
                string = (String)programCallDocument.getValue("quhrhlpt.receiver.listData.anchor", new int[]{i});
                String string8 = (String)programCallDocument.getValue("quhrhlpt.receiver.listData.hlpIdName", new int[]{i});
                string = string.trim();
                if (i == 0) {
                    m_startingAnchor = string;
                }
                if ((n6 = string8.indexOf(47)) != -1) {
                    string8 = string8.substring(n6 + 1, string8.length());
                }
                this.m_hash.put(string8, string);
            }
            byte[] byArray2 = (byte[])programCallDocument.getValue("quhrhlpt.document.help");
            try {
                string = new String(byArray2, "UTF8");
                m_help = string.trim();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (PcmlException pcmlException) {
            try {
                this.m_panel.InspectPCMLException(pcmlException);
            }
            catch (ClCommandException clCommandException) {
                if (bl) {
                    ClPanel.removeFromLibraryList(this.m_prdLib);
                }
                return;
            }
            MessageLog.logError((Object)("CP: " + pcmlException.getLocalizedMessage()));
            pcmlException.printStackTrace();
            MessageLog.logError((Object)"CP: *** Call to QUHRHLPT failed. ***");
            if (bl) {
                ClPanel.removeFromLibraryList(this.m_prdLib);
            }
            return;
        }
        if (bl) {
            ClPanel.removeFromLibraryList(this.m_prdLib);
        }
    }

    String getHelp() {
        return m_help;
    }

    void setHelp(String string) {
        m_help = string;
    }

    void setHelpIds(ClHelpId[] clHelpIdArray) {
        m_helpIds = clHelpIdArray;
    }

    String getAnchor(String string) {
        if (string != null) {
            string = string.toUpperCase();
        }
        return (String)this.m_hash.get(string);
    }

    String getStartingAnchor() {
        return m_startingAnchor;
    }

    ClHelpId[] getHelpIds() {
        return m_helpIds;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

