/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClButtonPanel;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClEditMenuListener;
import com.ibm.as400.ui.util.ClLayoutPanel;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClScrollPane;
import com.ibm.as400.ui.util.ClValues;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class ClCommandLineDialog
extends JDialog {
    private ClLayoutPanel m_layoutPanel;
    private ClButtonPanel m_advancedButtonPanel;
    private ClButtonPanel m_buttonPanel;
    private JPanel m_scrollPanel;
    private ClScrollPane m_scrollPane;
    private MenuManager m_viewMenuManager;
    private MenuManager m_fileMenuManager;
    private MenuManager m_editMenuManager;
    private MenuManager m_helpMenuManager;
    private long m_time;
    private static final int BUTTON_PANEL_HEIGHT = 100;

    ClCommandLineDialog(AS400 aS400, String string) {
        this(null, aS400, string);
    }

    ClCommandLineDialog(Frame frame, AS400 aS400, String string) {
        this(frame, aS400, string, true, true);
    }

    ClCommandLineDialog(Frame frame, AS400 aS400, String string, boolean bl, boolean bl2) {
        super(frame, true);
        if (frame != null) {
            ClPanel.m_icon = frame.getIconImage();
        }
        this.commonConstruct(aS400, string, bl, bl2);
    }

    ClCommandLineDialog(Dialog dialog, AS400 aS400, String string, boolean bl, boolean bl2) {
        super(dialog, true);
        this.commonConstruct(aS400, string, bl, bl2);
    }

    private void commonConstruct(AS400 aS400, String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        this.m_time = new Date().getTime();
        this.m_buttonPanel = new ClButtonPanel(this, this.m_layoutPanel, false);
        try {
            serializable = Class.forName("java.awt.Dialog$ModalityType");
            object3 = ((Class)serializable).getEnumConstants();
            object2 = null;
            for (int i = 0; i < ((?[])object3).length; ++i) {
                object = object3[i];
                if (!object.toString().equals("DOCUMENT_MODAL")) continue;
                object2 = object;
            }
            Method method = this.getClass().getMethod("setModalityType", object2.getClass());
            if (method != null && object2 != null) {
                method.invoke((Object)this, object2);
            }
        }
        catch (Exception exception) {
            System.out.println("Modality override bit the dust!");
            exception.printStackTrace();
        }
        this.setSize(500, 350);
        this.setLocationRelativeTo(null);
        this.m_layoutPanel = new ClLayoutPanel(aS400, string);
        this.m_buttonPanel.setLayoutPanel(this.m_layoutPanel);
        ClPanel.m_help = null;
        ClPanel.m_bAllowPrograms = bl;
        ClPanel.m_bPromptInteractive = bl2;
        serializable = this.getContentPane();
        ((Container)serializable).setLayout(new GridBagLayout());
        ((Component)serializable).setBackground(this.m_layoutPanel.getBackground());
        this.m_buttonPanel.setBackground(this.m_layoutPanel.getBackground());
        try {
            this.m_fileMenuManager = new MenuManager("com.ibm.as400.ui.util.ClMRI", "MAIN_FILE_MENU", null);
            object3 = new JMenuBar();
            ((JComponent)object3).setFont(ClPanel.m_scaledFont);
            this.m_fileMenuManager.getMenu().setFont(ClPanel.m_scaledFont);
            this.adjustFont(this.m_fileMenuManager.getMenu());
            ((JMenuBar)object3).add(this.m_fileMenuManager.getMenu());
            this.m_editMenuManager = new MenuManager("com.ibm.as400.ui.util.ClMRI", "MAIN_EDIT_MENU", null);
            this.m_editMenuManager.getMenu().setFont(ClPanel.m_scaledFont);
            this.adjustFont(this.m_editMenuManager.getMenu());
            ((JMenuBar)object3).add(this.m_editMenuManager.getMenu());
            this.m_viewMenuManager = new MenuManager("com.ibm.as400.ui.util.ClMRI", "MAIN_VIEW_MENU", null);
            this.m_viewMenuManager.getMenu().setFont(ClPanel.m_scaledFont);
            this.adjustFont(this.m_viewMenuManager.getMenu());
            ((JMenuBar)object3).add(this.m_viewMenuManager.getMenu());
            this.m_helpMenuManager = new MenuManager("com.ibm.as400.ui.util.ClMRI", "MAIN_HELP_MENU", null);
            this.m_helpMenuManager.getMenu().setFont(ClPanel.m_scaledFont);
            this.adjustFont(this.m_helpMenuManager.getMenu());
            ((JMenuBar)object3).add(this.m_helpMenuManager.getMenu());
            this.setJMenuBar((JMenuBar)object3);
            object2 = System.getProperty("java.version");
            int n = ((String)object2).indexOf(".");
            object = ((String)object2).substring(0, n);
            object2 = ((String)object2).substring(n + 1);
            String string2 = ((String)object2).substring(0, ((String)object2).indexOf("."));
            if (new Integer((String)object) <= 1 && new Integer(string2) <= 2) {
                this.getJMenuBar().unregisterKeyboardAction(KeyStroke.getKeyStroke(121, 0));
            } else {
                InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)object3, 2);
                inputMap.remove(KeyStroke.getKeyStroke(121, 0));
                SwingUtilities.replaceUIInputMap((JComponent)object3, 2, inputMap);
                ActionMap actionMap = SwingUtilities.getUIActionMap((JComponent)object3);
                actionMap.remove("takeFocus");
                SwingUtilities.replaceUIActionMap((JComponent)object3, actionMap);
            }
            this.m_editMenuManager.getMenu().addMenuListener(new ClEditMenuListener(this.m_editMenuManager));
        }
        catch (DisplayManagerException displayManagerException) {
            MessageLog.logError((Object)"CommandLineDialog: ", (Throwable)displayManagerException);
        }
        this.m_scrollPanel = new JPanel();
        this.m_scrollPanel.setLayout(new GridBagLayout());
        object3 = new GridBagConstraints();
        ((GridBagConstraints)object3).weightx = 0.5;
        ((GridBagConstraints)object3).weighty = 0.0;
        ((GridBagConstraints)object3).gridx = 0;
        ((GridBagConstraints)object3).gridy = 0;
        ((GridBagConstraints)object3).anchor = 18;
        ((GridBagConstraints)object3).gridwidth = -1;
        ((GridBagConstraints)object3).gridheight = -1;
        this.m_scrollPanel.add((Component)this.m_layoutPanel, object3);
        object2 = new JPanel();
        object3 = new GridBagConstraints();
        ((GridBagConstraints)object3).weightx = 0.5;
        ((GridBagConstraints)object3).weighty = 1.0;
        ((GridBagConstraints)object3).gridx = 1;
        ((GridBagConstraints)object3).gridy = 1;
        ((GridBagConstraints)object3).fill = 3;
        ((GridBagConstraints)object3).gridwidth = 0;
        ((GridBagConstraints)object3).gridheight = 0;
        this.m_scrollPanel.add((Component)object2, object3);
        this.m_scrollPane = new ClScrollPane();
        this.m_scrollPane.getViewport().add(this.m_scrollPanel);
        this.m_scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.m_scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.m_scrollPane.getVerticalScrollBar().setBlockIncrement(200);
        this.m_scrollPane.getHorizontalScrollBar().setBlockIncrement(200);
        object3 = new GridBagConstraints();
        ((GridBagConstraints)object3).weightx = 100.0;
        ((GridBagConstraints)object3).weighty = 100.0;
        ((GridBagConstraints)object3).gridx = 0;
        ((GridBagConstraints)object3).gridy = 0;
        ((GridBagConstraints)object3).fill = 1;
        ((GridBagConstraints)object3).anchor = 18;
        ((GridBagConstraints)object3).gridwidth = 20;
        ((GridBagConstraints)object3).gridheight = 7;
        ((Container)serializable).add(this.m_scrollPane, object3);
        this.m_advancedButtonPanel = new ClButtonPanel(this, this.m_layoutPanel, true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        ((Container)serializable).add(this.m_advancedButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        ((Container)serializable).add(this.m_buttonPanel, gridBagConstraints);
        this.m_scrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        this.m_scrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
        this.addKeyListener(this.m_advancedButtonPanel);
        this.addKeyListener(this.m_layoutPanel);
    }

    boolean prompt() throws ClParseException, ClCommandException {
        if (this.m_layoutPanel.loadDocument()) {
            if (this.m_layoutPanel.layoutPanel(this)) {
                if (!this.m_layoutPanel.hasAdvanced()) {
                    this.m_advancedButtonPanel.hideAdvanced();
                }
                this.m_layoutPanel.showAdvanced(true);
                this.m_layoutPanel.toggleKeywords();
                this.resizeDialog();
                Dimension dimension = this.getSize();
                this.m_layoutPanel.showAdvanced(false);
                this.m_layoutPanel.toggleKeywords();
                this.m_layoutPanel.assignFocus();
                this.setSize(dimension);
                this.setVisible(true);
                this.dispose();
                ClCommonLayout.cleanup();
                ClValues.cleanup();
                return !this.m_buttonPanel.isCanceled();
            }
            return false;
        }
        return false;
    }

    boolean showHelp() throws ClParseException, ClCommandException {
        if (this.m_layoutPanel.loadDocument()) {
            this.m_buttonPanel.handleHelp();
            return true;
        }
        return false;
    }

    void resizeDialog() {
        Dimension dimension = ClPanel.getDialogSize(this.getPreferredSize());
        Dimension dimension2 = this.getSize();
        if (this.isVisible()) {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            if (dimension.equals(dimension2)) {
                return;
            }
        }
        this.setSize(dimension);
        Dimension dimension3 = this.getToolkit().getScreenSize();
        Point point = this.getLocation();
        if (point.x + dimension.width + 20 > dimension3.width || point.y + dimension.height + 20 > dimension3.height) {
            this.setLocationRelativeTo(null);
        }
        this.validate();
    }

    void adjustFont(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = null;
        for (int i = 0; i < n; ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setFont(ClPanel.m_scaledFont);
        }
    }

    ClButtonPanel getAdvancedButtonPanel() {
        return this.m_advancedButtonPanel;
    }

    ClButtonPanel getMainButtonPanel() {
        return this.m_buttonPanel;
    }

    ClLayoutPanel getLayoutPanel() {
        return this.m_layoutPanel;
    }

    String getCommandLine() {
        return this.m_layoutPanel.getCLString();
    }

    void setCommandLine(String string) {
        this.m_layoutPanel.setCommandLine(string);
    }

    boolean isBatchCommand() {
        return this.m_layoutPanel.isBatchCommand();
    }

    int getDateFormat() {
        if (ClPanel.m_dateFormat == null) {
            return 0;
        }
        if (ClPanel.m_dateFormat.equals("*YMD")) {
            return 4;
        }
        if (ClPanel.m_dateFormat.equals("*MDY")) {
            return 3;
        }
        if (ClPanel.m_dateFormat.equals("*DMY")) {
            return 1;
        }
        if (ClPanel.m_dateFormat.equals("*JUL")) {
            return 2;
        }
        return 0;
    }

    MenuManager getFileMenuManager() {
        return this.m_fileMenuManager;
    }

    MenuManager getEditMenuManager() {
        return this.m_editMenuManager;
    }

    MenuManager getViewMenuManager() {
        return this.m_viewMenuManager;
    }

    MenuManager getHelpMenuManager() {
        return this.m_helpMenuManager;
    }

    void buildNewMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setFont(ClPanel.m_scaledFont);
        jMenuBar.add(this.m_fileMenuManager.getMenu());
        jMenuBar.add(this.m_editMenuManager.getMenu());
        try {
            this.m_viewMenuManager = new MenuManager("com.ibm.as400.ui.util.ClMRI", "MAIN_VIEW_MENU", null);
        }
        catch (DisplayManagerException displayManagerException) {
            // empty catch block
        }
        this.m_viewMenuManager.getMenu().setFont(ClPanel.m_scaledFont);
        this.adjustFont(this.m_viewMenuManager.getMenu());
        jMenuBar.add(this.m_viewMenuManager.getMenu());
        jMenuBar.add(this.m_helpMenuManager.getMenu());
        this.setJMenuBar(jMenuBar);
        String string = System.getProperty("java.version");
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        String string3 = string.substring(0, string.indexOf("."));
        if (new Integer(string2) <= 1 && new Integer(string3) <= 2) {
            this.getJMenuBar().unregisterKeyboardAction(KeyStroke.getKeyStroke(121, 0));
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(jMenuBar, 2);
            inputMap.remove(KeyStroke.getKeyStroke(121, 0));
            SwingUtilities.replaceUIInputMap(jMenuBar, 2, inputMap);
            ActionMap actionMap = SwingUtilities.getUIActionMap(jMenuBar);
            actionMap.remove("takeFocus");
            SwingUtilities.replaceUIActionMap(jMenuBar, actionMap);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

