/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClContextMenuManager;
import com.ibm.as400.ui.util.ClCopyKeyListener;
import com.ibm.as400.ui.util.ClFieldMouseHandler;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClStringBean;
import com.ibm.as400.ui.util.MessageViewer;
import java.io.IOException;
import java.util.Locale;
import javax.swing.text.JTextComponent;

class ClCommand {
    private String m_command;
    private String m_commandName;
    private String m_commandLibrary;
    private byte[] m_xml;
    private ClPanel m_panel;

    ClCommand() {
        this.m_commandName = "";
        this.m_commandLibrary = "";
        this.m_xml = null;
        this.m_panel = null;
    }

    ClCommand(String string, String string2, ClPanel clPanel, String string3) {
        this.m_commandName = string;
        this.m_commandLibrary = string2;
        this.m_panel = clPanel;
        this.m_command = string3;
    }

    String pad(String string) {
        String string2 = string;
        while (string2.length() < 10) {
            string2 = string2 + " ";
        }
        return string2;
    }

    void load() throws ClCommandException {
        AS400 aS400 = ClPanel.m_system;
        boolean bl = false;
        int[] nArray = new int[1];
        byte[] byArray = new byte[4];
        try {
            ProgramCallDocument programCallDocument;
            MessageLog.logError((Object)"CP: Beginning PCML Call..");
            MessageLog.logError((Object)"CP:    Constructing ProgramCallDocument for QCDRCMDD API...");
            String string = this.m_commandName.toUpperCase(Locale.ENGLISH);
            String string2 = this.m_commandLibrary.toUpperCase(Locale.ENGLISH);
            string = this.pad(string);
            string2 = this.pad(string2);
            try {
                programCallDocument = new ProgramCallDocument(aS400, "com.ibm.as400.ui.util.qcdrcmdd");
                programCallDocument.setValue("qcdrcmdd.name", (Object)(string + string2));
                MessageLog.logError((Object)"CP:    Calling QCDRCMDD API.");
                bl = programCallDocument.callProgram("qcdrcmdd");
            }
            catch (PcmlException pcmlException) {
                this.m_panel.InspectPCMLException(pcmlException);
                MessageLog.logError((Object)("CP: " + pcmlException.getLocalizedMessage()));
                pcmlException.printStackTrace();
                MessageLog.logError((Object)"CP: *** Call to QCDRCMDD failed. ***");
                if (pcmlException.getException() instanceof ObjectDoesNotExistException) {
                    try {
                        String string3 = ClPanel.m_system.getSystemName();
                        int n = ClPanel.m_system.getVersion();
                        int n2 = ClPanel.m_system.getRelease();
                        if (n == 4 && n2 < 4 || n < 4) {
                            this.m_panel.error(12, string3);
                            throw new ClCommandException(4);
                        }
                        this.ptfRequired(string3);
                        throw new ClCommandException(3);
                    }
                    catch (AS400SecurityException aS400SecurityException) {
                        throw new ClCommandException();
                    }
                    catch (IOException iOException) {
                        throw new ClCommandException();
                    }
                }
                throw new ClCommandException();
            }
            catch (RuntimeException runtimeException) {
                MessageLog.logError((Object)("CP: " + runtimeException.getLocalizedMessage()));
                runtimeException.printStackTrace();
                throw new ClCommandException();
            }
            if (!bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qcdrcmdd");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    String string4 = aS400MessageArray[i].getID();
                    String string5 = aS400MessageArray[i].getText();
                    if (string4 != null && string4.equals("CPF9801")) {
                        bl2 = true;
                    }
                    if (string4 != null && string4.equals("CPF9810")) {
                        bl3 = true;
                    }
                    if (string4 != null && string4.equals("CPF3CF2")) {
                        bl4 = true;
                    }
                    MessageLog.logError((Object)("CP:    " + string4 + " - " + string5));
                }
                if (bl2) {
                    string = string.trim();
                    string2 = string2.trim();
                    this.m_panel.displayAS400Message(30, (Object)string, (Object)string2);
                    throw new ClCommandException();
                }
                if (bl3) {
                    string = string.trim();
                    string2 = string2.trim();
                    this.m_panel.displayAS400Message(28, (Object)string2);
                    throw new ClCommandException();
                }
                if (bl4) {
                    this.m_panel.error(5, "QCDRCMDD");
                    throw new ClCommandException();
                }
                PanelManager panelManager = null;
                try {
                    panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", "ADVANCED_BUTTON_PANEL", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string6 = ClPanel.loadString("IDS_MESSAGE_ERROR");
                MessageViewer messageViewer = new MessageViewer(string6, panelManager);
                messageViewer.setSystem(ClPanel.m_system);
                messageViewer.addMessages(aS400MessageArray);
                messageViewer.setVisible(true);
                throw new ClCommandException();
            }
            int n = (Integer)programCallDocument.getValue("qcdrcmdd.receiver.bytesReturned", new int[]{0});
            int n3 = (Integer)programCallDocument.getValue("qcdrcmdd.receiver.bytesAvailable", new int[]{0});
            MessageLog.logError((Object)("CP: Bytes returned: " + n));
            MessageLog.logError((Object)("CP: Bytes available: " + n3));
            if (n < n3) {
                programCallDocument.setIntValue("qcdrcmdd.length", n3 + 8);
                MessageLog.logError((Object)"CP:    Calling QCDRCMDD API Second Time.");
                bl = programCallDocument.callProgram("qcdrcmdd");
                if (!bl) {
                    AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qcdrcmdd");
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        String string7 = aS400MessageArray[i].getID();
                        String string8 = aS400MessageArray[i].getText();
                        MessageLog.logError((Object)("CP:    " + string7 + " - " + string8));
                    }
                    MessageLog.logError((Object)"CP: ** Call to QCDRCMDD failed. See messages above **");
                    throw new ClCommandException();
                }
                int n4 = (Integer)programCallDocument.getValue("qcdrcmdd.receiver.bytesReturned", new int[]{0});
                int n5 = (Integer)programCallDocument.getValue("qcdrcmdd.receiver.bytesAvailable", new int[]{0});
                MessageLog.logError((Object)("CP: Bytes returned: " + n4));
                MessageLog.logError((Object)("CP: Bytes available: " + n5));
            }
            this.m_xml = (byte[])programCallDocument.getValue("qcdrcmdd.receiver.xml");
        }
        catch (PcmlException pcmlException) {
            this.m_panel.InspectPCMLException(pcmlException);
            MessageLog.logError((Object)("CP: " + pcmlException.getLocalizedMessage()));
            pcmlException.printStackTrace();
            MessageLog.logError((Object)"CP: *** Call to QCDRCMDD failed. ***");
            throw new ClCommandException();
        }
    }

    byte[] getXML() {
        return this.m_xml;
    }

    void setXML(byte[] byArray) {
        this.m_xml = byArray;
    }

    private void ptfRequired(String string) {
        String string2;
        AS400 aS400 = ClPanel.m_system;
        String string3 = null;
        try {
            MessageLog.logError((Object)"CP:    PTF Required. Checking Syntax.");
            string2 = new ProgramCallDocument(aS400, "com.ibm.as400.ui.util.qcapcmd");
            string2.setValue("qcapcmd.sourceCommand", (Object)this.m_command);
            string2.setValue("qcapcmd.length", (Object)new Integer(this.m_command.length()));
            string2.setValue("qcapcmd.controlblock.commandProcessing", (Object)new Integer(1));
            MessageLog.logError((Object)"CP:    Calling QCAPCMD API.");
            boolean bl = string2.callProgram("qcapcmd");
            string3 = bl ? ClPanel.loadString("IDS_SYNTAX_VALID") : ClPanel.loadString("IDS_SYNTAX_NOT_VALID");
        }
        catch (PcmlException pcmlException) {
            // empty catch block
        }
        string2 = ClPanel.loadString("IDS_MESSAGE_ERROR");
        String string4 = ClPanel.formatString("IDS_PTF_REQUIRED", string, "II12532", "http://www.ibm.com/servers/eserver/iseries/oper_nav/infoapars.htm");
        string3 = string3 != null ? string3 + "\n\n" + string4 : string4;
        ClStringBean clStringBean = new ClStringBean(string3);
        DataBean[] dataBeanArray = new DataBean[]{clStringBean};
        PanelManager panelManager = ClPanel.loadPanel("PANEL_COMMANDPREVIEW", dataBeanArray, this.m_panel);
        panelManager.setTitle(string2);
        JTextComponent jTextComponent = (JTextComponent)panelManager.getComponent("CP_TEXT_COMMANDPREVIEW");
        jTextComponent.setEditable(false);
        jTextComponent.requestFocus();
        ClContextMenuManager clContextMenuManager = null;
        try {
            clContextMenuManager = new ClContextMenuManager("com.ibm.as400.ui.util.ClMRI", null, "COPY_MENU", null);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
        }
        jTextComponent.addMouseListener(new ClFieldMouseHandler(jTextComponent, clContextMenuManager));
        jTextComponent.addKeyListener(new ClCopyKeyListener());
        panelManager.setVisible(true);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

