/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.HelpViewer;
import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClCommandLineDialog;
import com.ibm.as400.ui.util.ClHelp;
import com.ibm.as400.ui.util.ClLayoutPanel;
import com.ibm.as400.ui.util.ClPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class ClButtonPanel
extends ClPanel
implements ActionListener,
KeyListener {
    ClCommandLineDialog m_parent;
    ClLayoutPanel m_panel;
    boolean m_hasAdvanced;
    boolean m_bCanceled;
    PanelManager m_panelManager;
    boolean m_bAdvanced = false;
    boolean m_bAllParameters = false;

    public void cleanup() {
        this.m_parent = null;
        this.m_panel = null;
        this.m_panelManager = null;
    }

    ClButtonPanel(ClCommandLineDialog clCommandLineDialog, ClLayoutPanel clLayoutPanel, boolean bl) {
        this.m_parent = clCommandLineDialog;
        this.m_panel = clLayoutPanel;
        this.m_hasAdvanced = true;
        this.m_bCanceled = true;
        this.m_panelManager = null;
        String string = "BUTTON_PANEL";
        if (bl) {
            string = "ADVANCED_BUTTON_PANEL";
        }
        try {
            this.m_panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", string, null, (Container)this);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            return;
        }
        if (ClPanel.m_scaledFont == null) {
            if (!bl) {
                JComponent jComponent = (JComponent)this.m_panelManager.getComponent("BUTTON_PANEL_OK");
                ClPanel.m_scaledFont = jComponent.getFont();
            } else {
                JComponent jComponent = (JComponent)this.m_panelManager.getComponent("BUTTON_PANEL_ADVANCED");
                ClPanel.m_scaledFont = jComponent.getFont();
            }
        }
        this.m_bAdvanced = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            try {
                if (this.m_panel.processPromptOverride()) {
                    return;
                }
            }
            catch (ClCommandException clCommandException) {
                // empty catch block
            }
            if (!this.m_panel.verify()) {
                return;
            }
            this.m_bCanceled = false;
            this.m_parent.setVisible(false);
        } else if (string.equals("Cancel")) {
            this.m_bCanceled = true;
            this.m_parent.setVisible(false);
        } else if (string.equals("Advanced")) {
            try {
                this.m_panel.processPromptOverride();
            }
            catch (ClCommandException clCommandException) {
                // empty catch block
            }
            this.m_bAdvanced = false;
            this.m_panel.showAdvanced(true);
            this.changeButtonPanel("BASIC_BUTTON_PANEL");
            MenuManager menuManager = this.m_parent.getViewMenuManager();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
            jCheckBoxMenuItem.setState(true);
            JComponent jComponent = (JComponent)this.m_panelManager.getComponent("BUTTON_PANEL_BASIC");
            if (jComponent != null) {
                jComponent.requestFocus();
            }
        } else if (string.equals("Basic")) {
            this.m_bAdvanced = true;
            this.m_panel.showAdvanced(false);
            this.changeButtonPanel("ADVANCED_BUTTON_PANEL");
            MenuManager menuManager = this.m_parent.getViewMenuManager();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
            jCheckBoxMenuItem.setState(false);
            jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ALL_PARAMETERS");
            this.m_bAllParameters = false;
            jCheckBoxMenuItem.setState(false);
            JComponent jComponent = (JComponent)this.m_panelManager.getComponent("BUTTON_PANEL_ADVANCED");
            if (jComponent != null) {
                jComponent.requestFocus();
            }
        } else if (string.equals("Help")) {
            ClPanel.setCursor(this.m_panel, true);
            if (ClPanel.m_help == null) {
                ClPanel.m_help = new ClHelp(this.m_panel, this.m_panel.getPrdLib());
                ClPanel.m_help.setHelpIds(this.m_panel.getHelpIds());
                ClPanel.m_help.load();
            }
            if (ClPanel.m_help.getHelpIds().length == 0) {
                this.m_panel.error(7);
                ClPanel.setCursor(this.m_panel, false);
                return;
            }
            String string2 = ClPanel.m_help.getHelp();
            String string3 = ClPanel.m_help.getStartingAnchor();
            String string4 = System.getProperty("COMMAND_PROMPTER_HELP_OVERRIDE");
            if (string4 != null) {
                try {
                    String[] stringArray = string4.split("#");
                    String string5 = stringArray[0];
                    String string6 = stringArray[1];
                    Class<?> clazz = Class.forName(string5);
                    clazz.getMethod(string6, String.class, String.class, Component.class).invoke(null, string2, string3, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                HelpViewer helpViewer = new HelpViewer();
                helpViewer.setParentWindow((Window)this.m_parent);
                String string7 = this.m_panel.getCommandDescription();
                String string8 = ClPanel.loadString("IDS_HELP_TITLE");
                string8 = MessageFormat.format(string8, string7);
                helpViewer.setTitle(string8);
                try {
                    helpViewer.showHTML(string2, string3);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ClPanel.setCursor(this.m_panel, false);
        }
    }

    boolean isCanceled() {
        return this.m_bCanceled;
    }

    void setLayoutPanel(ClLayoutPanel clLayoutPanel) {
        this.m_panel = clLayoutPanel;
    }

    void hideAdvanced() {
        this.setVisible(false);
        this.m_bAdvanced = false;
        ClCommandLineDialog clCommandLineDialog = this.getMainDialog();
        MenuManager menuManager = clCommandLineDialog.getViewMenuManager();
        JMenuItem jMenuItem = menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
        jMenuItem.setEnabled(false);
        JMenu jMenu = menuManager.getMenu();
        jMenu.remove(jMenuItem);
        this.m_hasAdvanced = false;
    }

    ClCommandLineDialog getMainDialog() {
        Container container = this.getParent();
        while (!(container instanceof ClCommandLineDialog)) {
            container = container.getParent();
        }
        return (ClCommandLineDialog)container;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 120: {
                this.showAllParameters(!this.m_bAllParameters);
                keyEvent.consume();
                break;
            }
            case 121: {
                this.handleAdvancedToggle();
                keyEvent.consume();
                break;
            }
            case 27: 
            case 114: 
            case 123: {
                this.handleCancel();
                keyEvent.consume();
                break;
            }
            case 112: {
                this.handleHelp();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void toggleAllParameters() {
        this.showAllParameters(!this.m_bAllParameters);
    }

    void showAllParameters(boolean bl) {
        ClCommandLineDialog clCommandLineDialog = this.getMainDialog();
        MenuManager menuManager = clCommandLineDialog.getViewMenuManager();
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ALL_PARAMETERS");
        jCheckBoxMenuItem.setState(bl);
        this.m_panel.showAll(bl);
        this.m_bAllParameters = bl;
        if (!bl) {
            jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
            jCheckBoxMenuItem.setEnabled(true);
            if (!this.m_bAdvanced) {
                this.m_bAdvanced = true;
                this.handleAdvancedToggle();
                this.m_panelManager.setEnabled("BUTTON_PANEL_BASIC", true);
            } else {
                this.m_panelManager.setEnabled("BUTTON_PANEL_ADVANCED", true);
            }
        } else {
            try {
                this.m_panel.processPromptOverride();
            }
            catch (ClCommandException clCommandException) {
                // empty catch block
            }
            jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
            jCheckBoxMenuItem.setEnabled(false);
            if (!this.m_bAdvanced) {
                this.m_panelManager.setEnabled("BUTTON_PANEL_BASIC", false);
            } else {
                this.m_panelManager.setEnabled("BUTTON_PANEL_ADVANCED", false);
            }
        }
    }

    void setAdvanced(boolean bl) {
        this.m_hasAdvanced = bl;
    }

    void handleAdvancedToggle() {
        if (!this.m_hasAdvanced) {
            return;
        }
        if (this.m_bAdvanced) {
            this.actionPerformed(new ActionEvent(this, 0, "Advanced"));
        } else {
            this.actionPerformed(new ActionEvent(this, 0, "Basic"));
        }
    }

    void handleCancel() {
        this.actionPerformed(new ActionEvent(this, 0, "Cancel"));
    }

    void handleHelp() {
        this.actionPerformed(new ActionEvent(this, 0, "Help"));
    }

    void handleHowToUseHelp() {
        ClPanel.setCursor(this.m_panel, true);
        HelpViewer helpViewer = new HelpViewer("com/ibm/as400/ui/util/guiprompt");
        helpViewer.setParentWindow((Window)this.m_parent);
        helpViewer.showPage("com/ibm/as400/ui/util/guiprompt");
        ClPanel.setCursor(this.m_panel, false);
    }

    void changeButtonPanel(String string) {
        this.m_panelManager.setVisible(false);
        this.removeAll();
        try {
            this.m_panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", string, null, (Container)this);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            return;
        }
        this.revalidate();
        this.repaint();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

