/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.EmailUtils;
import java.io.File;

public final class Validate {
    private static final String EMPTY_STRING = "";
    private static final String ISNULL_VAL = "null value: ";
    private static final String ISEMPTY_VAL = "empty value: ";
    private static final String ISEMPTY_ARRAY = "empty array: ";
    private static final String HASNODATA_VAL = "expected data in value: ";
    private static final String ISNOTTRUE_VAL = "expected true value: ";
    private static final String ISNOTNUM_VAL = "expected numeric value: ";
    private static final String INVALIDNUM_VAL = "unexpected numeric value: ";
    private static final String ISNOTVALID_VAL = "expected valid object: ";
    private static final String ISNOTPOS_VAL = "expected positive value: ";
    private static final String ISNOTNEG_VAL = "expected negative value: ";
    private static final String ISNOTNONNEG_VAL = "expected non-negative value: ";
    private static final String ISNOTBOOLSTR_VAL = "expected true or false string: ";
    private static final String ISNOTREGFILE_VAL = "expected a regular file: ";
    private static final String INVALIDEMAIL_ADR = "invalid email address: ";

    protected Validate() {
    }

    public static boolean isTrue(boolean expression) throws AssertionError {
        if (!expression) {
            throw new AssertionError((Object)ISNOTTRUE_VAL);
        }
        return true;
    }

    public static boolean isTrue(boolean expression, String message) throws AssertionError {
        if (!expression) {
            throw new AssertionError((Object)(ISNOTTRUE_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isTrueFalseString(String value) throws AssertionError {
        Validate.isNotNull(value);
        if (value.compareToIgnoreCase(Boolean.TRUE.toString()) == 0 || value.compareToIgnoreCase(Boolean.FALSE.toString()) == 0) {
            return true;
        }
        throw new AssertionError((Object)(ISNOTBOOLSTR_VAL + value));
    }

    public static boolean isFile(File file) throws AssertionError {
        Validate.isNotNull(file, ISNOTREGFILE_VAL);
        if (!file.isFile()) {
            throw new AssertionError((Object)(ISNOTREGFILE_VAL + file.toString()));
        }
        return true;
    }

    public static boolean isNotNull(Object object) throws AssertionError {
        if (object == null) {
            throw new AssertionError((Object)ISNULL_VAL);
        }
        return true;
    }

    public static boolean isNotNull(Object object, String message) throws AssertionError {
        if (object == null) {
            throw new AssertionError((Object)(ISNULL_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isValid(Object object) throws AssertionError {
        if (object == null) {
            throw new AssertionError((Object)ISNOTVALID_VAL);
        }
        return true;
    }

    public static boolean isValid(Object object, String message) throws AssertionError {
        if (object == null) {
            throw new AssertionError((Object)(ISNOTVALID_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean hasData(String value) throws AssertionError {
        Validate.isNotNull(value);
        return Validate.thisHasData(value, EMPTY_STRING);
    }

    public static boolean hasData(String value, String message) throws AssertionError {
        Validate.isNotNull(value, message);
        return Validate.thisHasData(value, message);
    }

    private static boolean thisHasData(String value, String message) throws AssertionError {
        if (value.length() == 0) {
            throw new AssertionError((Object)(HASNODATA_VAL + message));
        }
        int i = 0;
        while (i < value.length()) {
            if (!Character.isWhitespace(value.charAt(i))) {
                throw new AssertionError((Object)(HASNODATA_VAL + message));
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotEmpty(String value) throws AssertionError {
        Validate.isNotNull(value);
        return Validate.thisIsNotEmpty(value, EMPTY_STRING);
    }

    public static boolean isNotEmpty(String value, String message) throws AssertionError {
        Validate.isNotNull(value, message);
        return Validate.thisIsNotEmpty(value, message);
    }

    public static boolean isNotEmpty(String[] value) throws AssertionError {
        Validate.isNotNull(value);
        if (value.length == 0) {
            throw new AssertionError((Object)ISEMPTY_ARRAY);
        }
        return true;
    }

    public static boolean isNotEmpty(String[] value, String message) throws AssertionError {
        Validate.isNotNull(value, message);
        if (value.length == 0) {
            throw new AssertionError((Object)(ISEMPTY_ARRAY + (message != null ? message : EMPTY_STRING)));
        }
        return true;
    }

    private static boolean thisIsNotEmpty(String value, String message) throws AssertionError {
        if (value.length() == 0) {
            throw new AssertionError((Object)(ISEMPTY_VAL + message));
        }
        int i = 0;
        while (i < value.length()) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return true;
            }
            ++i;
        }
        throw new AssertionError((Object)(ISEMPTY_VAL + (message == null ? EMPTY_STRING : message)));
    }

    public static boolean isNegative(int value) throws AssertionError {
        if (value >= 0) {
            throw new AssertionError((Object)ISNOTNEG_VAL);
        }
        return true;
    }

    public static boolean isNegative(int value, String message) throws AssertionError {
        if (value >= 0) {
            throw new AssertionError((Object)(ISNOTNEG_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isNegative(long value) throws AssertionError {
        if (value >= 0L) {
            throw new AssertionError((Object)ISNOTNEG_VAL);
        }
        return true;
    }

    public static boolean isNegative(long value, String message) throws AssertionError {
        if (value >= 0L) {
            throw new AssertionError((Object)(ISNOTNEG_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isNotNegative(int value) throws AssertionError {
        if (value < 0) {
            throw new AssertionError((Object)ISNOTNONNEG_VAL);
        }
        return true;
    }

    public static boolean isNotNegative(int value, String message) throws AssertionError {
        if (value < 0) {
            throw new AssertionError((Object)(ISNOTNONNEG_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isNotNegative(long value) throws AssertionError {
        if (value < 0L) {
            throw new AssertionError((Object)ISNOTNONNEG_VAL);
        }
        return true;
    }

    public static boolean isNotNegative(long value, String message) throws AssertionError {
        if (value < 0L) {
            throw new AssertionError((Object)(ISNOTNONNEG_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isPositive(int value) throws AssertionError {
        if (value <= 0) {
            throw new AssertionError((Object)ISNOTPOS_VAL);
        }
        return true;
    }

    public static boolean isPositive(int value, String message) throws AssertionError {
        if (value <= 0) {
            throw new AssertionError((Object)(ISNOTPOS_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isPositive(long value) throws AssertionError {
        if (value <= 0L) {
            throw new AssertionError((Object)ISNOTPOS_VAL);
        }
        return true;
    }

    public static boolean isPositive(long value, String message) throws AssertionError {
        if (value <= 0L) {
            throw new AssertionError((Object)(ISNOTPOS_VAL + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isNumeric(String value) throws AssertionError {
        Validate.isNotEmpty(value);
        try {
            Long.parseLong(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssertionError((Object)("expected numeric value: (" + value + ")"));
        }
        return true;
    }

    public static boolean isNumeric(String value, String message) throws AssertionError {
        Validate.isNotEmpty(value, message);
        try {
            Long.parseLong(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssertionError((Object)("expected numeric value: (" + value + "): " + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isNumbertBetweenEqual(String value, int lo, int hi) throws AssertionError {
        return Validate.isNumberBetweenEqual(value, lo, hi, EMPTY_STRING);
    }

    public static boolean isNumberBetweenEqual(String value, int lo, int hi, String message) throws AssertionError {
        int intValue;
        Validate.isNotNull(value, message);
        try {
            intValue = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssertionError((Object)("expected numeric value: (" + value + "): " + (message == null ? EMPTY_STRING : message)));
        }
        return Validate.isNumberBetweenEqual(intValue, lo, hi, message);
    }

    public static boolean isNumberBetweenEqual(int value, int lo, int hi) throws AssertionError {
        return Validate.isNumberBetweenEqual(value, lo, hi, EMPTY_STRING);
    }

    public static boolean isNumberBetweenEqual(int value, int lo, int hi, String message) throws AssertionError {
        if (value < lo || value > hi) {
            throw new AssertionError((Object)("unexpected numeric value: (" + value + " is <" + lo + " or >" + hi + "): " + (message == null ? EMPTY_STRING : message)));
        }
        return true;
    }

    public static boolean isValidSimpleEmailAddress(String emailAddress, String message) throws AssertionError {
        if (emailAddress == null || !EmailUtils.isSimpleEmailAddress(emailAddress)) {
            throw new AssertionError((Object)String.format("%s(%s): %s", INVALIDEMAIL_ADR, emailAddress, message == null ? EMPTY_STRING : message));
        }
        return true;
    }
}

