/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.PasswordPBKDFType;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPBKDF {
    private static final Logger logger = LoggerFactory.getLogger(PasswordPBKDF.class);
    private static final String DEFAULT_PBKDF_ALGORITHM = PasswordPBKDFType.DEFAULT_PBKDF2.getName();
    private static final String DEFAULT_PBKDF_ALGORITHM_ID = PasswordPBKDFType.DEFAULT_PBKDF2.getId();
    private static final int DEFAULT_PBKDF_HASH_BYTE_SIZE = PasswordPBKDFType.DEFAULT_PBKDF2.getHashByteSize();
    private static final int DEFAULT_PBKDF_SALT_BYTE_SIZE = PasswordPBKDFType.DEFAULT_PBKDF2.getSaltByteSize();
    private static final int DEFAULT_PBKDF_ITERATIONS = PasswordPBKDFType.DEFAULT_PBKDF2.getIterations();
    private static final int DEFAULT_PBKDF_ITERATIONS_FACTOR = PasswordPBKDFType.DEFAULT_PBKDF2.getIterationsFactor();
    private static final int ALGORITHM_INDEX = 0;
    private static final int ITERATION_INDEX = 1;
    private static final int SALT_INDEX = 2;
    private static final int HASH_INDEX = 3;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String createHash(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return PasswordPBKDF.createHash(password.toCharArray());
    }

    public static String createHash(char[] password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[DEFAULT_PBKDF_SALT_BYTE_SIZE];
        random.nextBytes(salt);
        byte[] hash = PasswordPBKDF.pbkdf2(password, salt, DEFAULT_PBKDF_ITERATIONS * DEFAULT_PBKDF_ITERATIONS_FACTOR, DEFAULT_PBKDF_HASH_BYTE_SIZE);
        return String.format("%s:%s:%s:%s", DEFAULT_PBKDF_ALGORITHM_ID, DEFAULT_PBKDF_ITERATIONS, PasswordPBKDF.toHex(salt), PasswordPBKDF.toHex(hash));
    }

    public static boolean validatePassword(String user, String password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return PasswordPBKDF.validatePassword(user, password.toCharArray(), correctHash);
    }

    public static boolean validatePassword(String user, char[] password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Object[] params = correctHash.split(":");
        if (params.length != 4) {
            logger.error(String.format("retrieved hash algorithm is corrupted, params: %s", Arrays.toString(params)));
            throw new InvalidKeySpecException("Retrieved password meta-data is corrupted, action = password needs to be reset");
        }
        String algId = params[0];
        if (algId == null) {
            throw new NoSuchAlgorithmException(String.format("Determined hash algorithm is not supported, id = %s", algId));
        }
        String algName = PasswordPBKDFType.getMatchForId(algId);
        if (!algName.equals(DEFAULT_PBKDF_ALGORITHM)) {
            throw new NoSuchAlgorithmException(String.format("Determined PBKDF hash algorithm, id = %s, name = %s, is not supported", algId, algName));
        }
        int iterations = 0;
        try {
            iterations = Integer.parseInt((String)params[1]);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error(String.format("retrieved hash algorithm is corrupted, params: %s", Arrays.toString(params)));
            throw new InvalidKeySpecException("Retrieved password meta-data is corrupted, action = password needs to be reset");
        }
        byte[] salt = PasswordPBKDF.fromHex((String)params[2]);
        byte[] hash = PasswordPBKDF.fromHex((String)params[3]);
        byte[] testHash = null;
        testHash = PasswordPBKDF.pbkdf2(password, salt, iterations * DEFAULT_PBKDF_ITERATIONS_FACTOR, hash.length);
        boolean isEqual = Arrays.equals(testHash, hash);
        logger.info(String.format("checked password hash for user %s, equal=%s", user, Boolean.toString(isEqual)));
        return isEqual;
    }

    static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        int i = 0;
        while (i < a.length && i < b.length) {
            diff |= a[i] ^ b[i];
            ++i;
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(DEFAULT_PBKDF_ALGORITHM);
        return skf.generateSecret(spec).getEncoded();
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        int i = 0;
        while (i < binary.length) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.valueOf(String.format("%0" + paddingLength + "d", 0)) + hex;
        }
        return hex;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < 10) {
                System.out.println(PasswordPBKDF.createHash("p\r\nassw0Rd!"));
                ++i;
            }
            boolean failure = false;
            System.out.println("Running tests...");
            int i2 = 0;
            while (i2 < 100) {
                String wrongPassword;
                String secondHash;
                String password = "" + i2;
                String hash = PasswordPBKDF.createHash(password);
                if (hash.equals(secondHash = PasswordPBKDF.createHash(password))) {
                    System.out.println("FAILURE: TWO HASHES ARE EQUAL!");
                    failure = true;
                }
                if (PasswordPBKDF.validatePassword("testuser", wrongPassword = "" + (i2 + 1), hash)) {
                    System.out.println("FAILURE: WRONG PASSWORD ACCEPTED!");
                    failure = true;
                }
                if (!PasswordPBKDF.validatePassword("testuser", password, hash)) {
                    System.out.println("FAILURE: GOOD PASSWORD NOT ACCEPTED!");
                    failure = true;
                }
                ++i2;
            }
            if (failure) {
                System.out.println("TESTS FAILED!");
            } else {
                System.out.println("TESTS PASSED!");
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex);
        }
    }
}

