/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.GravitySeverity;
import com.remainsoftware.common.util.IGravityReply;

public class GravityReply
implements IGravityReply {
    private GravitySeverity severity = null;
    private String message = "";
    private String additionalInfo = "";
    private Exception exception = null;
    public static final GravityReply OK = new GravityReply();
    public static final GravityReply ERROR = new GravityReply(GravitySeverity.ERROR, "");
    public static final GravityReply WARNING = new GravityReply(GravitySeverity.WARNING, "");

    public GravityReply() {
        this.severity = GravitySeverity.OK;
    }

    public GravityReply(GravitySeverity severity, String message) {
        this.severity = severity;
        if (message != null) {
            this.message = message;
        }
    }

    public GravityReply(GravitySeverity severity, String message, Exception exception) {
        this.severity = severity;
        if (message != null) {
            this.message = message;
        }
        this.exception = exception;
    }

    public GravityReply(GravitySeverity severity, String message, String additionalInfo) {
        this.severity = severity;
        if (message != null) {
            this.message = message;
        }
        if (additionalInfo != null) {
            this.additionalInfo = additionalInfo;
        }
    }

    @Override
    public GravitySeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(GravitySeverity severity) {
        this.severity = severity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (message != null) {
            this.message = message;
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setException(Throwable throwable) {
        this.exception = throwable != null ? new Exception(throwable) : null;
    }

    @Override
    public boolean hasError() {
        return this.severity == GravitySeverity.ERROR;
    }

    @Override
    public boolean hasWarning() {
        return this.severity == GravitySeverity.WARNING;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public boolean isOK() {
        return this.severity == GravitySeverity.OK;
    }

    public String toString() {
        return "Severity=[" + this.severity.getName() + "]; Message=[" + this.message + "]";
    }

    @Override
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        if (additionalInfo != null) {
            this.additionalInfo = additionalInfo;
        }
    }
}

