/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.FilesCopier;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final String NEWLINE = System.getProperty("line.separator");

    public static void copyStreamData(InputStream in, OutputStream out) throws Exception {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void writeFile(File file, String text, boolean append) throws IOException {
        if (!StringUtils.isEmpty(text)) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileWriter fileWriter = new FileWriter(file, append);){
                fileWriter.write(text);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void writeFile(String fileName, String text, boolean append) throws IOException {
        if (!StringUtils.isEmpty(text)) {
            File fileWrite = new File(fileName);
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileWriter fileWriter = new FileWriter(fileWrite, append);){
                fileWriter.write(text);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static String getFileFromURL(URL target) {
        if (target == null) {
            return null;
        }
        String protocol = target.getProtocol();
        if (protocol.equals("file")) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return FileUtils.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public static String normalizePath(String path) {
        char separatorChar = StringUtils.getSeparatorAsChar(path);
        String separator = String.valueOf(separatorChar);
        String dupSeparator = String.valueOf(separator) + separator;
        int dupIndex = path.indexOf(dupSeparator);
        int plen = path.length();
        if (dupSeparator.equals("\\") && dupIndex == 0) {
            dupIndex = path.indexOf(dupSeparator, 1);
        }
        if (dupIndex == -1) {
            if (plen > 1 && path.charAt(plen - 1) == separatorChar) {
                return path.substring(0, plen - 1);
            }
            return path;
        }
        StringBuffer newpath = new StringBuffer(plen);
        int last = 0;
        while (dupIndex != -1) {
            newpath.append(path.substring(last, dupIndex));
            while (path.charAt(dupIndex) == separatorChar) {
                if (++dupIndex != plen) continue;
                return newpath.toString();
            }
            newpath.append(separatorChar);
            last = dupIndex;
            dupIndex = path.indexOf(dupSeparator, last);
        }
        int end = plen > 1 && path.charAt(plen - 1) == separatorChar ? plen - 1 : plen;
        newpath.append(path.substring(last, end));
        return newpath.toString();
    }

    public static File getResourceFromPlugin(String bundleID, String relativePathToResource, boolean logError) throws IOException {
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            String msg = "did not find bundle with id: '" + bundleID + "'";
            if (logError) {
                logger.error(msg);
            }
            throw new FileNotFoundException(msg);
        }
        URL fileURL = bundle.getEntry(relativePathToResource);
        if (fileURL == null) {
            String msg = "did not find entry for resource: '" + relativePathToResource + "' in bundle:  '" + bundle.getSymbolicName() + "'";
            if (logError) {
                logger.warn(msg);
            }
            return null;
        }
        File file = null;
        URL resolvedURL = FileLocator.resolve((URL)fileURL);
        if (resolvedURL == null) {
            String msg = "failed to resolve resource in bundle (" + bundle.getSymbolicName() + ") for URL: '" + fileURL.toExternalForm() + "'";
            if (logError) {
                logger.error(msg);
            }
            throw new IOException(msg);
        }
        file = new File(FileUtils.fixFileURL(resolvedURL));
        return file;
    }

    public static URI fixFileURL(URL u) throws IOException {
        if (!"file".equals(u.getProtocol())) {
            throw new IOException("fixFileURL; expecting a file protocol on URL: " + u.toString());
        }
        return new File(u.getFile()).toURI();
    }

    public static void copyDirectory(java.nio.file.Path source, java.nio.file.Path target, boolean replace) throws IOException {
        CopyOption[] copyOptionArray;
        if (replace) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        CopyOption[] options = copyOptionArray;
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        FilesCopier tc = new FilesCopier(source, target, options);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
    }

    public static void copyFile(File srcFile, File destFile, boolean replace) throws IOException {
        CopyOption[] copyOptionArray;
        Validate.isNotNull(srcFile, "source file must be set");
        Validate.isNotNull(destFile, "destination file must be set");
        if (replace) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        CopyOption[] options = copyOptionArray;
        Files.copy(srcFile.toPath(), destFile.toPath(), options);
    }

    public static void copyFile(java.nio.file.Path srcFile, java.nio.file.Path destFile, boolean replace) throws IOException {
        CopyOption[] copyOptionArray;
        Validate.isNotNull(srcFile, "source file must be set");
        Validate.isNotNull(destFile, "destination file must be set");
        if (replace) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        CopyOption[] options = copyOptionArray;
        Files.copy(srcFile, destFile, options);
    }

    public static void deleteDirectory(java.nio.file.Path directory) throws IOException {
        File[] files = FileUtils.deleteFiles(directory, null, (IProgressMonitor)new NullProgressMonitor());
        if (files.length > 0) {
            throw new IOException("Failed to delete " + files[0].getAbsolutePath() + ".");
        }
        Files.delete(directory);
    }

    public static File[] deleteFiles(final java.nio.file.Path directory, final java.nio.file.Path[] excludedPaths, final IProgressMonitor monitor) {
        ArrayList filesNotRemoved;
        block9: {
            filesNotRemoved = new ArrayList();
            Path directoryPath = new Path(directory.toFile().getAbsolutePath());
            try {
                try {
                    final int[] fileCount = new int[1];
                    Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) throws IOException {
                            fileCount[0] = fileCount[0] + 1;
                            File file = path.toFile();
                            if (!file.canWrite() && !file.setWritable(true)) {
                                throw new IOException("Failed to set file writeable: " + file.getAbsolutePath());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    if (monitor != null) {
                        monitor.beginTask("Removing files", fileCount[0]);
                    }
                    Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>((IPath)directoryPath, filesNotRemoved){
                        private final /* synthetic */ IPath val$directoryPath;
                        private final /* synthetic */ ArrayList val$filesNotRemoved;
                        {
                            this.val$directoryPath = iPath;
                            this.val$filesNotRemoved = arrayList;
                        }

                        private boolean isExcluded(java.nio.file.Path arg) {
                            boolean excluded = false;
                            if (excludedPaths != null) {
                                java.nio.file.Path[] pathArray = excludedPaths;
                                int n = excludedPaths.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    java.nio.file.Path excludedPath = pathArray[n2];
                                    if (excludedPath.equals(arg)) {
                                        excluded = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            return excluded;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(java.nio.file.Path arg0, BasicFileAttributes arg1) throws IOException {
                            if (this.isExcluded(arg0)) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(java.nio.file.Path arg0, IOException arg1) throws IOException {
                            try {
                                if (!arg0.equals(directory)) {
                                    if (monitor != null) {
                                        IPath filePath = new Path(arg0.toFile().getAbsolutePath()).removeFirstSegments(this.val$directoryPath.segmentCount()).setDevice("");
                                        monitor.setTaskName("Removing file: " + filePath.toOSString());
                                    }
                                    Files.delete(arg0);
                                }
                            }
                            catch (Exception exception) {}
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path arg0, BasicFileAttributes arg1) throws IOException {
                            try {
                                if (!this.isExcluded(arg0)) {
                                    Files.delete(arg0);
                                }
                            }
                            catch (Exception e) {
                                this.val$filesNotRemoved.add(arg0.toFile());
                                logger.error("failed to delete file: " + arg0 + ", reason = " + StringUtils.extractMessage(e), (Throwable)e);
                            }
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    logger.error("exception occurred in visit for delete file", (Throwable)e);
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return filesNotRemoved.toArray(new File[filesNotRemoved.size()]);
    }

    public static String readFile(File file) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(NEWLINE);
            }
        }
        return buffer.toString();
    }

    public static void setWritable(java.nio.file.Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            private FileVisitResult setWritable(java.nio.file.Path path) throws IOException {
                File file = path.toFile();
                if (!file.canWrite() && !file.setWritable(true)) {
                    throw new IOException("Failed to set file writeable: " + file.getAbsolutePath());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                return this.setWritable(dir);
            }

            @Override
            public FileVisitResult visitFile(java.nio.file.Path arg0, BasicFileAttributes arg1) throws IOException {
                return this.setWritable(arg0);
            }
        });
    }

    public static File resolveLocation(String locationToResolve, Class clazz) throws IOException {
        File path = null;
        URL url = FrameworkUtil.getBundle((Class)clazz).getResource(locationToResolve);
        if (url != null && (url = FileLocator.resolve((URL)url)) != null) {
            path = new File(url.getPath());
        }
        return path;
    }
}

