/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.mail.util.BASE64EncoderStream;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger logger = LoggerFactory.getLogger(EmailUtils.class);
    public static final char DEFAULT_REPLACE_CHAR = '-';
    public static final String DEFAULT_REPLACE = String.valueOf('-');
    private static final Map<String, String> NONDIACRITICS = new HashMap<String, String>();
    static final String STRICT_EMAIL_PATTERN_REGEX = "^(?=.{1,64}@)[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*@[^-][A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
    static final String UNICODE_STRICT_EMAIL_PATTERN_REGEX = "^(?=.{1,64}@)[\\p{L}0-9_-]+(\\.[\\p{L}0-9_-]+)*@[^-][\\p{L}0-9-]+(\\.[\\p{L}0-9-]+)*(\\.[\\p{L}]{2,})$";
    static final String SIMPLE_EMAIL_PATTERN_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    static Pattern SIMPLE_EMAIL_VALIDATE_PATTERN;
    private static final Pattern DIACRITICS_PATTERN;
    private static final Pattern SQAUSH_MULTI_LINES;

    static {
        NONDIACRITICS.put(".", "");
        NONDIACRITICS.put("\"", "");
        NONDIACRITICS.put("'", "");
        NONDIACRITICS.put(" ", DEFAULT_REPLACE);
        NONDIACRITICS.put("]", DEFAULT_REPLACE);
        NONDIACRITICS.put("[", DEFAULT_REPLACE);
        NONDIACRITICS.put(")", DEFAULT_REPLACE);
        NONDIACRITICS.put("(", DEFAULT_REPLACE);
        NONDIACRITICS.put("=", DEFAULT_REPLACE);
        NONDIACRITICS.put("!", DEFAULT_REPLACE);
        NONDIACRITICS.put("/", DEFAULT_REPLACE);
        NONDIACRITICS.put("\\", DEFAULT_REPLACE);
        NONDIACRITICS.put("&", DEFAULT_REPLACE);
        NONDIACRITICS.put(",", DEFAULT_REPLACE);
        NONDIACRITICS.put("?", DEFAULT_REPLACE);
        NONDIACRITICS.put("\ufffd", DEFAULT_REPLACE);
        NONDIACRITICS.put("|", DEFAULT_REPLACE);
        NONDIACRITICS.put("<", DEFAULT_REPLACE);
        NONDIACRITICS.put(">", DEFAULT_REPLACE);
        NONDIACRITICS.put(";", DEFAULT_REPLACE);
        NONDIACRITICS.put(":", DEFAULT_REPLACE);
        NONDIACRITICS.put("_", DEFAULT_REPLACE);
        NONDIACRITICS.put("#", DEFAULT_REPLACE);
        NONDIACRITICS.put("~", DEFAULT_REPLACE);
        NONDIACRITICS.put("+", DEFAULT_REPLACE);
        NONDIACRITICS.put("*", DEFAULT_REPLACE);
        NONDIACRITICS.put("\u0141", "l");
        NONDIACRITICS.put("\u0142", "l");
        NONDIACRITICS.put("\ufffd", "ss");
        NONDIACRITICS.put("\ufffd", "ae");
        NONDIACRITICS.put("\ufffd", "o");
        NONDIACRITICS.put("\ufffd", "c");
        NONDIACRITICS.put("\u00d0", "d");
        NONDIACRITICS.put("\u00f0", "d");
        NONDIACRITICS.put("\u0110", "d");
        NONDIACRITICS.put("\u0111", "d");
        NONDIACRITICS.put("\u0189", "d");
        NONDIACRITICS.put("\u0256", "d");
        NONDIACRITICS.put("\u00de", "th");
        NONDIACRITICS.put("\u00fe", "th");
        SIMPLE_EMAIL_VALIDATE_PATTERN = Pattern.compile(SIMPLE_EMAIL_PATTERN_REGEX);
        DIACRITICS_PATTERN = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
        SQAUSH_MULTI_LINES = Pattern.compile("(\r?\n|\r){2,}");
    }

    public static String convertDiacritics(String text) {
        text = Normalizer.normalize(text, Normalizer.Form.NFD);
        text = DIACRITICS_PATTERN.matcher(text).replaceAll("");
        return text;
    }

    public static String sanitizeFileName(String name) {
        return name.replaceAll("[:\\\\/*?|<> \"]", "_");
    }

    public static String makeAsciiFileName(String text) {
        String str = text;
        if (str == null) {
            return null;
        }
        str = EmailUtils.convertDiacritics(str);
        if ((str = EmailUtils.stripNonDiacritics(str)).length() == 0) {
            return text;
        }
        return str;
    }

    private static String stripNonDiacritics(String text) {
        StringBuffer ret = new StringBuffer();
        String lastchar = null;
        int i = 0;
        while (i < text.length()) {
            String toReplace;
            String source = text.substring(i, i + 1);
            String replace = NONDIACRITICS.get(source);
            String string = toReplace = replace == null ? String.valueOf(source) : replace;
            if (DEFAULT_REPLACE.equals(lastchar) && DEFAULT_REPLACE.equals(toReplace)) {
                toReplace = "";
            } else {
                lastchar = toReplace;
            }
            ret.append(toReplace);
            ++i;
        }
        if (ret.length() > 0 && '-' == ret.charAt(ret.length() - 1)) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public static String removeUrl(String str) {
        String regex = "\\b(https?|ftp|file|telnet|http|Unsure)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        str = str.replaceAll(regex, "");
        return str;
    }

    public static String removeExtendedChars(String str) {
        return str.replaceAll("[^\\x00-\\x7F]", " ");
    }

    public static String getEmailAddressDomain(String emailAddress) {
        String[] parts;
        if (!StringUtils.isEmpty(emailAddress) && (parts = emailAddress.split("@")).length == 2) {
            return parts[1];
        }
        return "";
    }

    public static boolean isSimpleEmailAddress(String emailAddress) {
        if (!StringUtils.isEmpty(emailAddress)) {
            Matcher matcher = SIMPLE_EMAIL_VALIDATE_PATTERN.matcher(emailAddress);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isAcceptedEmailDomain(String emailAddress, String preferredDomain, String acceptedDomains) {
        String[] domains;
        if (StringUtils.isEmpty(emailAddress)) {
            return false;
        }
        String domainName = EmailUtils.getEmailAddressDomain(emailAddress);
        if (StringUtils.isEmpty(domainName)) {
            return false;
        }
        if (!StringUtils.isEmpty(preferredDomain) && domainName.equalsIgnoreCase(preferredDomain = preferredDomain.replace("@", ""))) {
            return true;
        }
        if (StringUtils.isEmpty(acceptedDomains) || acceptedDomains.trim().equals("*")) {
            return true;
        }
        String[] stringArray = domains = acceptedDomains.split(",");
        int n = domains.length;
        int n2 = 0;
        while (n2 < n) {
            String domain = stringArray[n2];
            if (!StringUtils.isEmpty(domain = domain.replace("@", "").trim()) && (domain.contains("*") || domain.contains("?") ? StringUtils.simpleMatchFilter(domainName, domain, false) : domainName.equalsIgnoreCase(domain))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void sendMailOauth(String smtpServerHost, String smtpServerPort, String smtpUserName, String smtpUserAccessToken, String fromUserEmail, String fromUserFullName, String toEmail, String subject, String body, boolean debug) {
        block15: {
            Validate.isNotEmpty(smtpServerHost);
            Validate.isNotEmpty(smtpServerPort);
            Validate.isNotEmpty(smtpUserName);
            Validate.isNotEmpty(smtpUserAccessToken);
            Validate.isNotEmpty(fromUserEmail);
            Validate.isNotEmpty(fromUserFullName);
            Validate.isNotEmpty(toEmail);
            Validate.isNotEmpty(subject);
            Validate.isNotEmpty(body);
            SMTPTransport transport = null;
            try {
                try {
                    Properties props = System.getProperties();
                    props.put("mail.transport.protocol", "smtp");
                    props.put("mail.smtp.port", smtpServerPort);
                    props.put("mail.smtp.starttls.enable", "true");
                    if (debug) {
                        props.put("mail.debug", "true");
                        props.put("mail.debug.auth", "true");
                    }
                    Session session = Session.getDefaultInstance((Properties)props);
                    session.setDebug(debug);
                    MimeMessage msg = new MimeMessage(session);
                    msg.setFrom((Address)new InternetAddress(fromUserEmail, fromUserFullName));
                    msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toEmail));
                    msg.setSubject(subject);
                    msg.setContent((Object)body, "text/html");
                    transport = new SMTPTransport(session, null);
                    transport.connect(smtpServerHost, smtpUserName, null);
                    transport.issueCommand("AUTH XOAUTH2 " + new String(BASE64EncoderStream.encode((byte[])String.format("user=%s\u0001auth=Bearer %s\u0001\u0001", smtpUserName, smtpUserAccessToken).getBytes())), 235);
                    transport.sendMessage((Message)msg, msg.getAllRecipients());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (MessagingException e) {
                            logger.error(String.format("failed to close smtp session, reason = %s", StringUtils.extractMessage((Exception)((Object)e))));
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (transport != null) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException e) {
                        logger.error(String.format("failed to close smtp session, reason = %s", StringUtils.extractMessage((Exception)((Object)e))));
                    }
                }
                throw throwable;
            }
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.error(String.format("failed to close smtp session, reason = %s", StringUtils.extractMessage((Exception)((Object)e))));
                }
            }
        }
    }

    public static void main(String[] args) {
        EmailUtils.sendMailOauth("smtp.gmail.com", "587", "walter.ridderhof@gmail.com", "ya29.a0AeTM1idE0Ll76YKhC2Go_rxNioO2SfYE0_dyVyTcNfDuUy232ttLGOtmM8UC-Ov1s38kmTsPN2vyJGWU2uvLjzpFwfNe2stzWC-7V4Jk-5KN5cX0GeRl7iqaJWTDsPVf6vPfloTmPuUeyszvcKfoJbh0Sn0oaCgYKAYYSARMSFQHWtWOmgYS3Pni6NMl_ADaEGAcSxQ0163", "walter.ridderhof@gmail.com", "Walter", "walter.ridderhof@gmail.com", "Sending mail with Gmail SMTP and Java Mail", "Hi,<br><br>This is a programmatic email.", true);
    }
}

