/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDirVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(DeleteDirVisitor.class);
    private boolean suppressAndLogExceptions = false;
    private boolean force = false;

    public DeleteDirVisitor() {
        this.suppressAndLogExceptions = false;
    }

    public DeleteDirVisitor(boolean suppressAndLogExceptions) {
        this.suppressAndLogExceptions = suppressAndLogExceptions;
    }

    public DeleteDirVisitor(boolean suppressAndLogExceptions, boolean force) {
        this.suppressAndLogExceptions = suppressAndLogExceptions;
        this.force = force;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Validate.isNotNull(file, "path must be set");
        logger.trace("deleting file: " + file.toString());
        try {
            if (!this.force) {
                Files.delete(file);
            } else {
                FileUtils.forceDelete((File)file.toFile());
            }
        }
        catch (IOException e) {
            String causeMsg = null;
            Throwable cause = e.getCause();
            if (this.suppressAndLogExceptions) {
                if (cause != null) {
                    causeMsg = StringUtils.extractMessage(cause);
                }
                logger.error("failed to delete file: " + file.toString() + ", message = " + e.getClass().getSimpleName() + ": " + e.getMessage() + (causeMsg != null ? ", cause = " + causeMsg : ""));
            }
            throw e;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc == null) {
            logger.trace("deleting directory: " + dir.toString());
            try {
                if (!this.force) {
                    Files.delete(dir);
                } else {
                    FileUtils.forceDelete((File)dir.toFile());
                }
            }
            catch (IOException e) {
                String causeMsg = null;
                Throwable cause = e.getCause();
                if (this.suppressAndLogExceptions) {
                    if (cause != null) {
                        causeMsg = StringUtils.extractMessage(cause);
                    }
                    logger.error("failed to delete directory: " + dir.toString() + ", message = " + e.getClass().getSimpleName() + ": " + e.getMessage() + (causeMsg != null ? ", cause = " + causeMsg : ""));
                }
                throw e;
            }
            return FileVisitResult.CONTINUE;
        }
        throw exc;
    }
}

