/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import com.remainsoftware.common.util.ValidateFailException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    private static final Calendar cal = new GregorianCalendar();
    private static final int dstOffset = cal.get(16);
    private static final List<Long> times = Arrays.asList(TimeUnit.DAYS.toMillis(365L), TimeUnit.DAYS.toMillis(30L), TimeUnit.DAYS.toMillis(1L), TimeUnit.HOURS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
    private static final List<String> timesString = Arrays.asList("year", "month", "day", "hour", "minute", "second");
    private static final int tzOffset = cal.get(15);
    private static final int tzCorrection = tzOffset + dstOffset;

    public static Calendar centuryDateToCalendar(String pDate) throws Exception {
        Validate.isNotNull(pDate);
        if (pDate.trim().length() == 0) {
            return null;
        }
        try {
            if (Integer.parseInt(pDate) == 0) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid century date (" + pDate + "), reason = value could not be parsed (NumberFormatException)", e);
        }
        ArrayList<String> centuryDateElem = new ArrayList<String>();
        if (pDate.length() != 7) {
            throw new Exception("Invalid century date (" + pDate + "), reason = length is not equal to 7");
        }
        String century = pDate.substring(0, 1);
        String year = pDate.substring(1, 3);
        String month = pDate.substring(3, 5);
        String day = pDate.substring(5, 7);
        centuryDateElem.add(century);
        centuryDateElem.add(year);
        centuryDateElem.add(month);
        centuryDateElem.add(day);
        int e = Integer.parseInt((String)centuryDateElem.get(0));
        int y = Integer.parseInt((String)centuryDateElem.get(1));
        int m = Integer.parseInt((String)centuryDateElem.get(2)) - 1;
        int d = Integer.parseInt((String)centuryDateElem.get(3));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (e == 1) {
            calendar.set(y + 2000, m, d);
        } else if (e == 0) {
            calendar.set(y + 1900, m, d);
        } else {
            throw new Exception("Invalid century digit (" + e + "), reason = century must be \"0\" (1900) or \"1\" (2000)");
        }
        return calendar;
    }

    public static String centuryDateToLocaleDate(String cd) throws Exception {
        Validate.isNotNull(cd);
        if (cd.trim().length() == 0) {
            return "";
        }
        try {
            if (Integer.parseInt(cd) == 0) {
                return "";
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid century date (" + cd + "), reason value could not be parsed", e);
        }
        Calendar cal = DateUtils.centuryDateToCalendar(cd);
        return DateFormat.getDateInstance().format(cal.getTime());
    }

    public static long dateToUnixUTCTimestamp(String date) throws Exception {
        if (date == null) {
            return 0L;
        }
        int year = Integer.parseInt(date.substring(0, 4)) - 1900;
        int month = Integer.parseInt(date.substring(4, 6)) - 1;
        int day = Integer.parseInt(date.substring(6, 8));
        int hour = Integer.parseInt(date.substring(8, 10));
        int minute = Integer.parseInt(date.substring(10, 12));
        int second = Integer.parseInt(date.substring(12, 14));
        return Date.UTC(year, month, day, hour, minute, second);
    }

    public static long fileTimestampToUnixUTCTimestamp(long timestamp) {
        if (timestamp < 0L) {
            return 0L;
        }
        return timestamp / 1000L * 1000L;
    }

    public static long fileTimestampToUnixUTCZonedTimestamp(long timestamp) {
        if (timestamp < 0L) {
            return 0L;
        }
        long rndTimestamp = timestamp / 1000L * 1000L;
        long UTCTimestamp = rndTimestamp + (long)DateUtils.getUTCTimezoneCorrection();
        return UTCTimestamp;
    }

    public static String formatAsCenturyDate(Date date) {
        Validate.isNotNull(date);
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTime(date);
        String year = Integer.toString(cal.get(1)).substring(2, 4);
        String month = Integer.toString(cal.get(2) + 1);
        String century = Integer.toString(Integer.parseInt(Integer.toString(cal.get(1)).substring(0, 2)) - 19);
        String day = Integer.toString(cal.get(5));
        if (month.length() == 2) {
            month = month;
        }
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 2) {
            day = day;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(century) + year + month + day;
    }

    public static String formatAsHHMMSS(Date date) {
        String second;
        String minute;
        Validate.isNotNull(date);
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTime(date);
        String hour = Integer.toString(cal.get(11));
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = Integer.toString(cal.get(12))).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = Integer.toString(cal.get(13))).length() == 1) {
            second = "0" + second;
        }
        return String.valueOf(hour) + minute + second;
    }

    public static String formatAsDateTime(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat fullTime = DateFormat.getDateTimeInstance(3, 2);
        return fullTime.format(date);
    }

    public static String formatAsDBTime(Date date) {
        Validate.isNotNull(date);
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        df.setLenient(false);
        return df.format(date);
    }

    public static String formatAsTime(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat mediumTime = DateFormat.getTimeInstance(2);
        return mediumTime.format(date);
    }

    public static String formatAsTimeShort(Date time) {
        if (time == null) {
            return "";
        }
        DateFormat shortTime = DateFormat.getTimeInstance(3);
        return shortTime.format(time);
    }

    public static long getDifferenceInDays(Calendar dateFrom, Calendar dateTo) {
        if (dateFrom == null || dateTo == null) {
            return 0L;
        }
        int year = dateFrom.get(1);
        int month = dateFrom.get(2);
        int day = dateFrom.get(5);
        long from = new GregorianCalendar(year, month, day).getTime().getTime();
        year = dateTo.get(1);
        month = dateTo.get(2);
        day = dateTo.get(5);
        long to = new GregorianCalendar(year, month, day).getTime().getTime();
        double difference = to - from;
        long days = Math.round(difference / 8.64E7);
        return days;
    }

    public static int getUTCTimezoneCorrection() {
        if (tzCorrection != 0) {
            return tzCorrection * -1;
        }
        return 0;
    }

    public static String HHMMSSToLocaleTime(String time) {
        if (time == null || time.equals("0")) {
            return "";
        }
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        String formatedTime = "";
        ArrayList<String> timeElem = new ArrayList<String>();
        if (time.length() != 6) {
            throw new IllegalArgumentException("Invalid time (" + time + "), reason = time must be in \"HHMMSS\" format");
        }
        String h = time.substring(0, 2);
        String m = time.substring(2, 4);
        String s = time.substring(4, 6);
        timeElem.add(h);
        timeElem.add(m);
        timeElem.add(s);
        int h2 = Integer.parseInt((String)timeElem.get(0));
        int m2 = Integer.parseInt((String)timeElem.get(1));
        int s2 = Integer.parseInt((String)timeElem.get(2));
        cal.clear();
        cal.setLenient(false);
        cal.set(11, h2);
        cal.set(12, m2);
        cal.set(13, s2);
        formatedTime = DateFormat.getTimeInstance().format(cal.getTime());
        return formatedTime;
    }

    @Deprecated
    public static boolean isLong(String val) {
        return StringUtils.isDigits(val);
    }

    public static boolean isValidYYYYMMDDOrLocaleDate(String st) throws Exception {
        Validate.isNotNull(st);
        Calendar cal2 = Calendar.getInstance(Locale.getDefault());
        if (StringUtils.isDigits(st)) {
            ArrayList<String> dateElem = DateUtils.parseDateYYYYMMDD(st);
            int year = Integer.parseInt(dateElem.get(0));
            int month = Integer.parseInt(dateElem.get(1));
            int day = Integer.parseInt(dateElem.get(2));
            cal2.clear();
            cal2.setLenient(false);
            cal2.set(year, month - 1, day);
            cal2.getTime();
            return true;
        }
        return DateUtils.localeDateStrictToYYYYMMDD(st) != null;
    }

    public static String localeDateStrictToYYYYMMDD(String date) throws ParseException {
        Validate.isNotNull(date);
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        DateFormat.getDateInstance().setLenient(false);
        Date dt = DateFormat.getDateInstance().parse(date);
        if (!date.equalsIgnoreCase(DateFormat.getDateInstance().format(dt))) {
            return null;
        }
        cal.clear();
        cal.setLenient(false);
        cal.setTime(dt);
        cal.getTime();
        String year = Integer.toString(cal.get(1));
        String month = Integer.toString(cal.get(2) + 1);
        String day = Integer.toString(cal.get(5));
        if (month.length() == 2) {
            month = month;
        }
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 2) {
            day = day;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(year) + month + day;
    }

    public static String localeDateTOCCYYMMDD(String localDate) throws ParseException {
        Validate.isNotNull(localDate);
        DateFormat df = DateFormat.getDateInstance();
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        df.setLenient(false);
        Date date = df.parse(localDate);
        if (localDate.equalsIgnoreCase(df.format(date))) {
            String year = "";
            String month = "";
            String day = "";
            cal.setTime(date);
            year = Integer.toString(cal.get(1)).substring(0, 4);
            month = Integer.toString(cal.get(2) + 1);
            day = Integer.toString(cal.get(5));
            if (month.length() == 2) {
                month = month;
            }
            if (month.length() == 1) {
                month = "0" + month;
            }
            if (day.length() == 2) {
                day = day;
            }
            if (day.length() == 1) {
                day = "0" + day;
            }
            return String.valueOf(year) + month + day;
        }
        return null;
    }

    public static String localeDateToCenturyDate(Date date) {
        Validate.isNotNull(date);
        Calendar cal2 = Calendar.getInstance(Locale.getDefault());
        cal2.setTime(date);
        String year = Integer.toString(cal2.get(1)).substring(2, 4);
        String month = Integer.toString(cal2.get(2) + 1);
        String century = Integer.toString(Integer.parseInt(Integer.toString(cal2.get(1)).substring(0, 2)) - 19);
        String day = Integer.toString(cal2.get(5));
        if (month.length() == 2) {
            month = month;
        }
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 2) {
            day = day;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(century) + year + month + day;
    }

    public static String localeDateTOCenturyDate(String localDate) throws ParseException {
        Validate.isNotNull(localDate);
        DateFormat df = DateFormat.getDateInstance();
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        df.setLenient(false);
        Date date = df.parse(localDate);
        if (localDate.equalsIgnoreCase(df.format(date))) {
            String century = "";
            String year = "";
            String month = "";
            String day = "";
            cal.setTime(date);
            year = Integer.toString(cal.get(1)).substring(2, 4);
            month = Integer.toString(cal.get(2) + 1);
            century = Integer.toString(Integer.parseInt(Integer.toString(cal.get(1)).substring(0, 2)) - 19);
            day = Integer.toString(cal.get(5));
            if (month.length() == 2) {
                month = month;
            }
            if (month.length() == 1) {
                month = "0" + month;
            }
            if (day.length() == 2) {
                day = day;
            }
            if (day.length() == 1) {
                day = "0" + day;
            }
            return String.valueOf(century) + year + month + day;
        }
        return null;
    }

    public static String localeDateTOOS400Timestamp(String localDateFormat) throws ParseException {
        DateFormat dtf = DateFormat.getDateTimeInstance();
        dtf.setLenient(false);
        Date date = null;
        date = dtf.parse(localDateFormat);
        if (localDateFormat.equalsIgnoreCase(dtf.format(date))) {
            int year = dtf.getCalendar().get(1);
            int hour = dtf.getCalendar().get(11);
            int minute = dtf.getCalendar().get(12);
            int second = dtf.getCalendar().get(13);
            int century = 20 - Integer.parseInt(Integer.toString(year).substring(0, 2));
            if (century == 1) {
                century = 0;
            } else if (century == 0) {
                century = 1;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            return String.valueOf(century) + sdf.format(date) + hour + minute + second;
        }
        return null;
    }

    public static long localeDateToTimestamp(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static String localeDateToYYYYMMDD(Date date) {
        Validate.isNotNull(date);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTime(date);
        String year = Integer.toString(calendar.get(1));
        String month = Integer.toString(calendar.get(2) + 1);
        String day = Integer.toString(calendar.get(5));
        if (month.length() == 2) {
            month = month;
        }
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 2) {
            day = day;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(year) + month + day;
    }

    public static String localeTimeToHHMMSS(String localTime) throws ParseException {
        return DateUtils.localeTimeToHHMMSS(localTime, "");
    }

    public static String localeTimeToHHMMSS(String localTime, String pSeparator) throws ParseException {
        Validate.isNotNull(localTime);
        Validate.isNotNull(pSeparator);
        Calendar cal2 = Calendar.getInstance(Locale.getDefault());
        DateFormat df = DateFormat.getTimeInstance();
        df.setLenient(false);
        Date dt = df.parse(localTime);
        cal2.clear();
        cal2.setLenient(false);
        cal2.setTime(dt);
        cal2.getTime();
        String h = Integer.toString(cal2.get(11));
        String m = Integer.toString(cal2.get(12));
        String s = Integer.toString(cal2.get(13));
        if (h.length() == 1) {
            h = "0" + h;
        }
        if (m.length() == 1) {
            m = "0" + m;
        }
        if (s.length() == 1) {
            s = "0" + s;
        }
        return String.valueOf(h) + pSeparator + m + pSeparator + s;
    }

    public static String localeTimeToHHMMSS(Time time) throws ParseException {
        DateFormat df = DateFormat.getTimeInstance();
        return DateUtils.localeTimeToHHMMSS(df.format(time));
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.toDuration(123L));
        System.out.println(DateUtils.toDuration(1230L));
        System.out.println(DateUtils.toDuration(12300L));
        System.out.println(DateUtils.toDuration(123000L));
        System.out.println(DateUtils.toDuration(1230000L));
        System.out.println(DateUtils.toDuration(12300000L));
        System.out.println(DateUtils.toDuration(123000000L));
        System.out.println(DateUtils.toDuration(1230000000L));
        System.out.println(DateUtils.toDuration(12300000000L));
        System.out.println(DateUtils.toDuration(123000000000L));
    }

    public static String OS400TimestampToLocaleDate(String timeStamp) throws Exception {
        Date date = DateUtils.OS400TimestampToDate(timeStamp);
        if (date == null) {
            return "0000000000000";
        }
        DateFormat dt = DateFormat.getDateTimeInstance();
        return dt.format(date);
    }

    public static Date OS400TimestampToDate(String timeStamp) throws Exception {
        Validate.isNotNull(timeStamp);
        if (timeStamp.charAt(0) < ' ') {
            new Exception("Invalid OS400 timestamp (" + timeStamp + "), reason = value must be a 13 digit string in the format CYYMMDDHHMMSS");
        }
        if (timeStamp.equals("0000000000000")) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        DateFormat df = DateFormat.getDateInstance();
        DateFormat tf = DateFormat.getTimeInstance();
        if (StringUtils.isDigits(timeStamp)) {
            if (timeStamp.length() != 13) {
                new Exception("Invalid OS400 timestamp (" + timeStamp + "), reason = value must be a 13 digit string in the format CYYMMDDHHMMSS");
            }
            df.setLenient(false);
            tf.setLenient(false);
            cal.clear();
            cal.setLenient(false);
            String centuryDate = DateUtils.centuryDateToLocaleDate(timeStamp.substring(0, 7));
            String time = DateUtils.HHMMSSToLocaleTime(timeStamp.substring(7, 13));
            df.parse(centuryDate);
            tf.parse(time);
            cal.set(df.getCalendar().get(1), df.getCalendar().get(2), df.getCalendar().get(5), tf.getCalendar().get(11), tf.getCalendar().get(12), tf.getCalendar().get(13));
            try {
                return cal.getTime();
            }
            catch (Exception exception) {
                tf.setLenient(true);
                cal.setLenient(true);
                return cal.getTime();
            }
        }
        return null;
    }

    public static ArrayList<String> parseDateYYYYMMDD(String date) {
        Validate.isNotNull(date);
        if (date.length() == 8) {
            ArrayList<String> dateElem = new ArrayList<String>();
            String y = date.substring(0, 4);
            String m = date.substring(4, 6);
            String d = date.substring(6, 8);
            dateElem.add(y);
            dateElem.add(m);
            dateElem.add(d);
            return dateElem;
        }
        throw new IllegalArgumentException("failed to parse date (date=" + date + "), reason = date length is not equal to 8");
    }

    public static Date timestampToDate(long timeStamp) {
        if (timeStamp < 0L) {
            return null;
        }
        Date date = new Date(timeStamp);
        return date;
    }

    public static Date timeToDate(String time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setLenient(false);
        return formatter.parse(time);
    }

    public static long timeToTimestamp(String time) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setLenient(false);
        Date tempDate = formatter.parse(time);
        return tempDate.getTime();
    }

    public static long timeToTimestamp(String time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setLenient(false);
        Date tempDate = formatter.parse(time);
        return tempDate.getTime();
    }

    public static String toDate(Date date) {
        Validate.isNotNull(date);
        Calendar cal = Calendar.getInstance();
        String year = "";
        String month = "";
        String day = "";
        cal.setTime(date);
        year = Integer.toString(cal.get(1));
        month = Integer.toString(cal.get(2) + 1);
        day = Integer.toString(cal.get(5));
        if (month.length() == 2) {
            month = month;
        }
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 2) {
            day = day;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return DateUtils.YYMMDDToLocaleDate(String.valueOf(year) + month + day);
    }

    public static String toDuration(long duration) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < times.size()) {
            Long current = times.get(i);
            long temp = duration / current;
            if (temp > 0L) {
                res.append(temp).append(" ").append(timesString.get(i)).append(temp > 1L ? "s" : "").append(" ago");
                break;
            }
            ++i;
        }
        if ("".equals(res.toString())) {
            return "0 second ago";
        }
        return res.toString();
    }

    public static String YYMMDDToLocaleDate(String date) {
        Validate.isNotNull(date);
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        ArrayList<String> dateElem = new ArrayList<String>();
        if (date.length() != 8) {
            throw new IllegalArgumentException("Invalid date (" + date + "), reason = length is not equal to 8");
        }
        String y = date.substring(0, 4);
        String m = date.substring(4, 6);
        String d = date.substring(6, 8);
        dateElem.add(y);
        dateElem.add(m);
        dateElem.add(d);
        int y2 = Integer.parseInt((String)dateElem.get(0));
        int m2 = Integer.parseInt((String)dateElem.get(1));
        int d2 = Integer.parseInt((String)dateElem.get(2));
        cal.clear();
        cal.setLenient(false);
        cal.set(y2, m2 - 1, d2);
        return DateFormat.getDateInstance().format(cal.getTime());
    }

    public static Date YYYYMMDDHHMMSSToLocaleDate(String time) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setLenient(false);
        return formatter.parse(time);
    }

    public static String YYYYMMDDToLocaleDate(String st) {
        Validate.isNotNull(st);
        DateFormat df = DateFormat.getDateInstance();
        Calendar cal1 = Calendar.getInstance(Locale.getDefault());
        ArrayList<String> dateElem = DateUtils.parseDateYYYYMMDD(st);
        int y = Integer.parseInt(dateElem.get(0));
        int m = Integer.parseInt(dateElem.get(1));
        int d = Integer.parseInt(dateElem.get(2));
        cal1.clear();
        cal1.setLenient(false);
        cal1.set(y, m, d);
        return df.format(cal1.getTime());
    }

    public static String calendarToLocaleStringDate(Calendar calendar) {
        try {
            Validate.isNotNull(calendar);
        }
        catch (ValidateFailException validateFailException) {
            return "";
        }
        int day = calendar.get(5);
        String month = calendar.getDisplayName(2, 1, Locale.getDefault());
        int year = calendar.get(1);
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(month) + " " + day + ", " + year);
        return buf.toString();
    }

    public static String dateToLocaleStringDate(Date date) {
        try {
            Validate.isNotNull(date);
        }
        catch (ValidateFailException validateFailException) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        String month = calendar.getDisplayName(2, 1, Locale.getDefault());
        int year = calendar.get(1);
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(month) + " " + day + ", " + year);
        return buf.toString();
    }

    public static String convertTodayToLocaleStringDate() {
        Calendar todaysDate = Calendar.getInstance();
        return DateUtils.convertToLocaleStringDate(todaysDate.get(1), todaysDate.get(2), todaysDate.get(5));
    }

    public static String convertToLocaleStringDate(int pYear, int pMonth, int pDay) {
        DateFormat df = DateFormat.getDateInstance();
        Calendar c = Calendar.getInstance();
        c.set(1, pYear);
        c.set(2, pMonth);
        c.set(5, pDay);
        return df.format(c.getTime()).toString();
    }

    public static int[] getLocaleDateValues(String pLocaleDateString) throws Exception {
        int month;
        if (StringUtils.isEmpty(pLocaleDateString)) {
            throw new Exception("Failed to get the integer values of the locale date because null or an empty string is passed as input.");
        }
        String monthString = pLocaleDateString.substring(0, 3);
        if (monthString.equalsIgnoreCase("Jan")) {
            month = 0;
        } else if (monthString.equalsIgnoreCase("Feb")) {
            month = 1;
        } else if (monthString.equalsIgnoreCase("Mar")) {
            month = 2;
        } else if (monthString.equalsIgnoreCase("Apr")) {
            month = 3;
        } else if (monthString.equalsIgnoreCase("May")) {
            month = 4;
        } else if (monthString.equalsIgnoreCase("Jun")) {
            month = 5;
        } else if (monthString.equalsIgnoreCase("Jul")) {
            month = 6;
        } else if (monthString.equalsIgnoreCase("Aug")) {
            month = 7;
        } else if (monthString.equalsIgnoreCase("Sep")) {
            month = 8;
        } else if (monthString.equalsIgnoreCase("Oct")) {
            month = 9;
        } else if (monthString.equalsIgnoreCase("Nov")) {
            month = 10;
        } else if (monthString.equalsIgnoreCase("Dec")) {
            month = 11;
        } else {
            throw new Exception("The '" + pLocaleDateString + "' date is not a valid locale date: The month must be the first three letters of a month.");
        }
        int indexOfComma = pLocaleDateString.indexOf(",");
        if (indexOfComma != 5 && indexOfComma != 6) {
            throw new Exception("The '" + pLocaleDateString + "' date is not a valid locale date: A comma must be after the day number.");
        }
        try {
            int day = Integer.valueOf(pLocaleDateString.substring(4, indexOfComma));
            if (day < 1 || day > 31) {
                throw new Exception("The '" + pLocaleDateString + "' date is not a valid locale date: The day must be between 1 and 31.");
            }
            int year = Integer.valueOf(pLocaleDateString.substring(indexOfComma + 2));
            if (year < 1752 || year > 9999) {
                throw new Exception("The '" + pLocaleDateString + "' date is not a valid locale date: The year must be between 1752 and 9999.");
            }
            return new int[]{year, month, day};
        }
        catch (NumberFormatException e) {
            throw new Exception("The '" + pLocaleDateString + "' date is not a valid locale date.", e);
        }
    }
}

