/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.branding;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IUrlService;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogService;

public class WelcomeScreen {
    private static final String LOCATION_WWW = "https://miworkplace.com";
    private static final String LOCATION_MAIL = "mailto:helpdesk@remainsoftware.com";
    private static final String LOCATION_USER_GUIDE = "https://miworkplace.com/docs/";
    private static final String LOCATION_VIDEOS = "https://miworkplace.com/index.php?content=videos";
    private static final String START_ANCHOR = "#start";
    @Inject
    private IStylingEngine engine;
    @Inject
    private LogService logger;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private Display display;
    @Inject
    private IUrlService urlService;
    private Map<String, Image> fImages = new HashMap<String, Image>();

    @Inject
    public WelcomeScreen() {
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        layout.verticalSpacing = 20;
        Composite mainComponent = new Composite(parent, 0);
        mainComponent.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        mainComponent.setLayoutData((Object)gridData);
        this.engine.setId((Object)mainComponent, "miworkplace-welcome");
        Label l = new Label(mainComponent, 0);
        l.setText(Messages.welcome_header);
        this.engine.setId((Object)l, "miworkplace-welcome-title");
        l = new Label(mainComponent, 0);
        l.setText("Choose one of the actions below:");
        this.engine.setId((Object)l, "miworkplace-welcome-quote");
        try {
            Composite panel = this.buildButtonPanel(mainComponent);
            GridData layoutData = new GridData();
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalAlignment = 2;
            panel.setLayoutData((Object)layoutData);
        }
        catch (IOException ioe) {
            this.logger.log(1, "Could not read image from bundle.", (Throwable)ioe);
        }
    }

    @PreDestroy
    private void dispose() {
        this.fImages.forEach((key, image) -> image.dispose());
    }

    private Composite buildButtonPanel(Composite parent) throws IOException {
        ToolBar panel = new ToolBar(parent, 0);
        RowLayout layout = new RowLayout();
        panel.setLayout((Layout)layout);
        this.createButton(panel, Messages.welcome_videos, LOCATION_VIDEOS);
        this.createButton(panel, Messages.welcome_newconn, START_ANCHOR);
        this.createButton(panel, Messages.welcome_website, LOCATION_WWW);
        this.createButton(panel, Messages.welcome_userguide, LOCATION_USER_GUIDE);
        this.createButton(panel, Messages.welcome_email, LOCATION_MAIL);
        return panel;
    }

    private void createButton(ToolBar panel, String pText, String pTarget) throws IOException {
        ToolItem button = new ToolItem(panel, 0x800000);
        button.setToolTipText(pText);
        button.setImage(this.createImage(pTarget));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            if (pText.equals(Messages.welcome_newconn)) {
                this.openConnectionWizard();
            } else {
                this.urlService.open(pTarget);
            }
        }));
    }

    private Image createImage(String pTarget) throws IOException {
        if (!this.fImages.containsKey(pTarget)) {
            Image image = new Image((Device)this.display, this.getImageInputStream(pTarget));
            this.fImages.put(pTarget, image);
        }
        return this.fImages.get(pTarget);
    }

    private InputStream getImageInputStream(String type) throws IOException {
        String iconPath = null;
        if (type.equals(LOCATION_MAIL)) {
            iconPath = "icons/mail.png";
        } else if (type.equals(LOCATION_VIDEOS)) {
            iconPath = "icons/video.png";
        } else if (type.equals(LOCATION_USER_GUIDE)) {
            iconPath = "icons/information.png";
        } else if (type.equals(LOCATION_WWW)) {
            iconPath = "icons/web.png";
        } else if (type.equals(START_ANCHOR)) {
            iconPath = "icons/add.png";
        }
        if (iconPath == null) {
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL resource = bundle.getResource(iconPath);
        return resource.openStream();
    }

    private void openConnectionWizard() {
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.newConnection", null);
        this.handlerService.executeHandler(command);
    }
}

