/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.branding;

import java.io.IOException;
import java.io.InputStream;
import miworkplace.i18n.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class AboutDialog
extends Dialog {
    public AboutDialog(Shell shell) {
        super(shell);
        this.setShellStyle(48);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.about_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        InputStream in = null;
        try {
            in = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getResource("/images/about-side.jpg").openStream();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Image image = new Image((Device)Display.getCurrent(), in);
        parent.addDisposeListener(e -> image.dispose());
        Label sideImage = new Label(parent, 2048);
        sideImage.setImage(image);
        GridData layoutData = new GridData(4, 4, true, true);
        Label text = new Label(parent, 64);
        text.setText(this.getDialogText());
        text.setLayoutData((Object)layoutData);
        parent.pack();
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.common_close, true);
    }

    private String getDialogText() {
        String sep = System.lineSeparator();
        String text = "MiWorkplace" + sep + sep + "Version:  1.37.0" + sep + "Build Id: " + String.valueOf(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getVersion()) + sep + sep + "(c) Copyright Remain Software 2016-2024.  All rights reserved." + sep + "https://www.miworkplace.com" + sep + sep + "This product includes software developed by" + sep + "Apache Software Foundation http://apache.org" + sep + "Eclipse Software Foundation http://eclipse.org" + sep + "and others." + sep + sep + "Please visit https://remainsoftware.com for more information.";
        return text;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }
}

