/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.syntax;

import java.util.ArrayList;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.File;
import miworkplace.ast.rpg.Parameter;
import miworkplace.ast.rpg.PositionalAbstractProgramFragment;
import miworkplace.ast.rpg.Procedure;
import miworkplace.ast.rpg.Program;
import miworkplace.ast.rpg.Prototype;
import miworkplace.ast.rpg.ReturnValue;
import miworkplace.ast.rpg.Subroutine;
import miworkplace.ast.rpg.Task;
import miworkplace.ast.rpg.iledocs.ILEDocs;
import miworkplace.ast.rpg.iledocs.ILEDocsBuilder;
import miworkplace.ast.rpg.syntax.TokenManipulator;
import miworkplace.ast.rpg.token.Include;
import miworkplace.ast.rpg.token.Parenthesis;
import miworkplace.ast.rpg.token.SpecificationType;
import miworkplace.ast.rpg.token.control.Keyword;
import miworkplace.ast.rpg.tokenizer.Line;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.ast.rpg.tokenizer.Token;

public class Parser {
    private static Prototype lastPrototype;

    public static void parse(AST ast, Token[] tokens) {
        ast.setProgram(new Program());
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].getLine().getLineType().equals((Object)LineType.Header)) {
                TokenManipulator.setFlags(tokens[i]);
                if (tokens[i] instanceof Keyword) {
                    Keyword keyword = (Keyword)tokens[i];
                    i = Parser.processControlToken(keyword, i, tokens);
                    ast.addControlKeyword(keyword);
                }
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Procedure)) {
                i = Parser.processProcedureTokens(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Comment)) {
                i = Parser.processCommentTokens(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Copy)) {
                i = Parser.processIncludes(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Include)) {
                i = Parser.processIncludes(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.IledocsStart)) {
                i = Parser.processIledocsComments(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Declaration)) {
                i = Parser.processDeclarations(ast, tokens[i], i, tokens);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.File)) {
                i = Parser.processFiles(ast, tokens[i], i, tokens);
            } else if (Parser.isSubroutineBegin(tokens, i)) {
                if (Parser.isFreeFormatLine(tokens, i)) {
                    if (tokens.length >= i + 2 && tokens[i].getLineNumber() == tokens[i + 1].getLineNumber()) {
                        subroutine = new Subroutine(tokens[i + 1].getData());
                        subroutine.setStartLine(tokens[i].getLineNumber());
                        ast.addSubroutine(subroutine);
                        ++i;
                    }
                } else if (tokens[i].getLineNumber() == tokens[i - 1].getLineNumber()) {
                    subroutine = new Subroutine(tokens[i - 1].getData());
                    subroutine.setStartLine(tokens[i].getLineNumber());
                    ast.addSubroutine(subroutine);
                }
            }
            ++i;
        }
        Parser.matchDocumentationToFragments(ast);
        ast.buildFinished();
    }

    private static boolean isSubroutineBegin(Token[] tokens, int i) {
        if (!tokens[i].getData().equalsIgnoreCase("BEGSR")) {
            return false;
        }
        if (Parser.isFreeFormatLine(tokens, i)) {
            return Parser.isFirstTokenInLine(tokens, i);
        }
        return tokens[i].getPosition() == 26;
    }

    private static boolean isFirstTokenInLine(Token[] tokens, int i) {
        return tokens[i].getLine().iterator().next() == tokens[i];
    }

    private static boolean isFreeFormatLine(Token[] tokens, int i) {
        Line line = tokens[i].getLine();
        String lineData = line.getData();
        if (lineData.trim().isEmpty() || lineData.length() < 6) {
            return true;
        }
        return lineData.charAt(5) != 'C' && lineData.charAt(5) != 'c';
    }

    private static int processDeclarations(AST ast, Token startToken, int pos, Token[] tokens) {
        int i = pos;
        int line = -1;
        StringBuilder name = new StringBuilder();
        Token token = null;
        boolean isProcedureInterface = false;
        int procedureInterfaceLine = 0;
        StringBuilder returnValueBuilder = new StringBuilder();
        while (i < tokens.length && tokens[i].getLine().getLineType() == LineType.Declaration) {
            token = tokens[i];
            if (isProcedureInterface && token.getLineNumber() != procedureInterfaceLine) {
                isProcedureInterface = false;
                procedureInterfaceLine = 0;
                if (ast.getProcedures().length > 0) {
                    ast.getProcedures()[ast.getProcedures().length - 1].setReturnValue(new ReturnValue(returnValueBuilder.toString()));
                }
            }
            if (token.getPosition() == 24 && token.getData().length() == 2) {
                if (token.getData().equalsIgnoreCase("PR")) {
                    if (name.length() > 0) {
                        lastPrototype = new Prototype(name.toString());
                        ast.addPrototype(lastPrototype);
                        name.setLength(0);
                        lastPrototype.setStartLine(line);
                        line = -1;
                    }
                } else if (token.getData().equalsIgnoreCase("DS")) {
                    name.setLength(0);
                    lastPrototype = null;
                } else if (token.getData().equalsIgnoreCase("PI")) {
                    isProcedureInterface = true;
                    procedureInterfaceLine = token.getLineNumber();
                }
            } else if (token.getPosition() == 24 && token.getData().length() == 1) {
                if (token.getData().equalsIgnoreCase("S")) {
                    name.setLength(0);
                    lastPrototype = null;
                }
            } else if (token.getPosition() >= 26 && token.getPosition() < 80) {
                if (!token.getData().equals(".")) {
                    if (isProcedureInterface) {
                        if (token.getPosition() >= 33 && token.getPosition() <= 42) {
                            returnValueBuilder.append(token.getData());
                        }
                    } else {
                        if (name.length() > 0 && lastPrototype != null) {
                            lastPrototype.addParameter(new Parameter(name.toString()));
                        }
                        name.setLength(0);
                    }
                }
            } else if (token.getPosition() >= 7 && token.getPosition() < 80 && !token.getData().equals(".")) {
                name.append(token.getData());
                if (line == -1) {
                    line = token.getLineNumber();
                }
            }
            ++i;
        }
        if (isProcedureInterface && returnValueBuilder.length() > 0 && ast.getProcedures().length > 0) {
            ast.getProcedures()[ast.getProcedures().length - 1].setReturnValue(new ReturnValue(returnValueBuilder.toString()));
        }
        return --i;
    }

    private static int processFiles(AST ast, Token startToken, int pos, Token[] tokens) {
        int i = pos;
        String name = startToken.getData().replaceFirst("F", "");
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        if (!name.isEmpty()) {
            File file = new File();
            file.setName(name);
            file.setStartLine(startToken.getLineNumber());
            ast.addFile(file);
        }
        ++i;
        while (i < tokens.length && tokens[i].getLine().getLineType() == LineType.File) {
            if (tokens[i].getPosition() == 6) break;
            ++i;
        }
        return --i;
    }

    private static int processControlToken(Token token, int pos, Token[] tokens) {
        int i = pos;
        if (token instanceof Keyword) {
            Keyword keyword = (Keyword)token;
            ++i;
            while (i < tokens.length) {
                if (tokens[i] instanceof Keyword || !tokens[i].getLine().getLineType().equals((Object)LineType.Header)) break;
                if (!(tokens[i] instanceof SpecificationType)) {
                    Parenthesis p;
                    keyword.addChildren(tokens[i]);
                    if (tokens[i] instanceof Parenthesis && (p = (Parenthesis)tokens[i]).getType().equals((Object)Parenthesis.Type.RIGHT)) {
                        ++i;
                        break;
                    }
                }
                ++i;
            }
            --i;
        }
        return i;
    }

    private static int processProcedureTokens(AST ast, Token startToken, int pos, Token[] allTokens) {
        int i = pos;
        Token token = null;
        Procedure proc = null;
        StringBuilder procNameBuilder = new StringBuilder();
        String procName = "";
        boolean exported = false;
        int startLine = -1;
        while (i < allTokens.length && allTokens[i].getLine().getLineType() == LineType.Procedure) {
            token = allTokens[i];
            if (token.getPosition() == 24 && token.getData().length() == 1) {
                if (token.getData().equalsIgnoreCase("B")) {
                    procName = procNameBuilder.toString();
                } else if (token.getData().equalsIgnoreCase("E") && procName.length() > 0) {
                    proc = new Procedure();
                    proc.setName(procName);
                    proc.setExported(exported);
                    proc.setStartLine(startLine);
                    proc.setEndLine(token.getLineNumber());
                    ast.addProcedure(proc);
                    procNameBuilder = new StringBuilder();
                    exported = false;
                    startLine = -1;
                    procName = "";
                }
            } else if (token.getPosition() >= 7 && token.getPosition() < 44) {
                if (startLine == -1) {
                    startLine = token.getLineNumber();
                }
                if (!token.getData().equals(".")) {
                    procNameBuilder.append(token.getData());
                }
            } else if (token.getPosition() > 7 && token.getPosition() < 80 && token.getData().equalsIgnoreCase("EXPORT")) {
                exported = true;
            }
            ++i;
        }
        if (procName.length() > 0) {
            proc = new Procedure();
            proc.setName(procName);
            proc.setExported(exported);
            proc.setStartLine(startLine);
            proc.setEndLine(token.getLineNumber());
            ast.addProcedure(proc);
        }
        return --i;
    }

    private static int processCommentTokens(AST ast, Token startToken, int pos, Token[] allTokens) {
        String data = startToken.getData();
        String[] parts = data.split(" ");
        if (parts.length > 0 && Task.KEYWORDS.contains(parts[0].toUpperCase())) {
            Task task = new Task(ast, data.substring(parts[0].length()).trim(), parts[0]);
            task.setLineNumber(startToken.getLineNumber());
            ast.addTask(task);
        }
        return pos;
    }

    private static int processIncludes(AST ast, Token token, int pos, Token[] allTokens) {
        if (token instanceof Include && ((Include)token).getIncludedFile() != null) {
            ast.addInclude((Include)token);
        }
        return pos;
    }

    private static int processIledocsComments(AST ast, Token token, int pos, Token[] allTokens) {
        ArrayList<Token> iledocsTokens = new ArrayList<Token>();
        Token t = null;
        int i = pos;
        block4: while (i < allTokens.length) {
            t = allTokens[i];
            switch (t.getLine().getLineType()) {
                case IledocsStart: {
                    if (t.getData().equals("/**") && t.getPosition() == 6) break;
                    iledocsTokens.add(t);
                    break;
                }
                case Iledocs: {
                    if (t.getData().equals("*") && t.getPosition() == 7) break;
                    iledocsTokens.add(t);
                    break;
                }
                default: {
                    break block4;
                }
            }
            ++i;
        }
        ILEDocs comment = ILEDocsBuilder.build(iledocsTokens.toArray(new Token[iledocsTokens.size()]));
        ast.addDocumentation(comment);
        return --i;
    }

    private static void matchDocumentationToFragments(AST ast) {
        PositionalAbstractProgramFragment[] fragments = ast.getDocumentableFragments();
        if (fragments.length > 0) {
            PositionalAbstractProgramFragment matchedFragment = null;
            ILEDocs[] iLEDocsArray = ast.getDocumentation();
            int n = iLEDocsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILEDocs documentation = iLEDocsArray[n2];
                if (Parser.isMainProgramDocumentation(documentation, ast)) {
                    matchedFragment = ast.getProgram();
                } else {
                    PositionalAbstractProgramFragment[] positionalAbstractProgramFragmentArray = fragments;
                    int n3 = fragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PositionalAbstractProgramFragment fragment = positionalAbstractProgramFragmentArray[n4];
                        if (!fragment.isDocumented()) {
                            if (matchedFragment == null) {
                                if (documentation.getStartLine() < fragment.getStartLine()) {
                                    matchedFragment = fragment;
                                }
                            } else if (documentation.getStartLine() < fragment.getStartLine() && matchedFragment.getStartLine() - documentation.getStartLine() > fragment.getStartLine() - documentation.getStartLine()) {
                                matchedFragment = fragment;
                            }
                        }
                        ++n4;
                    }
                }
                if (matchedFragment != null && !matchedFragment.isDocumented()) {
                    matchedFragment.setDocumentation(documentation);
                    documentation.setDocumentedObject(matchedFragment);
                }
                matchedFragment = null;
                ++n2;
            }
        }
    }

    private static boolean isMainProgramDocumentation(ILEDocs documentation, AST ast) {
        Keyword[] hspecs = ast.getControlKeywords();
        if (hspecs.length > 0) {
            return documentation.getStartLine() < hspecs[0].getLineNumber();
        }
        return false;
    }
}

