/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.List;
import miworkplace.ui.editor.rpg.ast.Token;
import org.apache.commons.lang3.StringUtils;

public class TokensToStringTransformer {
    public static String transform(List<Token> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return "";
        }
        if (tokens.size() == 1) {
            return tokens.get((int)0).value;
        }
        Token prev = tokens.get(0);
        StringBuilder s = new StringBuilder(prev.value);
        for (Token token : tokens.subList(1, tokens.size())) {
            if (token.line != prev.line) {
                s.append(" ");
                s.append(token.value);
            } else {
                int distance = token.lineOffset - (prev.lineOffset + prev.value.length());
                if (distance > 0) {
                    s.append(StringUtils.repeat((char)' ', (int)distance));
                }
                s.append(token.value);
            }
            prev = token;
        }
        return s.toString();
    }
}

