/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import miworkplace.ui.editor.rpg.ast.CommentIdentifier;
import miworkplace.ui.editor.rpg.ast.CompositeToken;
import miworkplace.ui.editor.rpg.ast.SpaceToken;
import miworkplace.ui.editor.rpg.ast.StringToken;
import miworkplace.ui.editor.rpg.ast.Token;
import org.apache.commons.lang3.StringUtils;

public class Preprocessor {
    public List<Token> process(List<Token> tokens) {
        LinkedList<Token> processedTokens = new LinkedList<Token>();
        if (tokens.isEmpty()) {
            return processedTokens;
        }
        ListIterator<Token> iterator = tokens.listIterator();
        block0: while (iterator.hasNext()) {
            Token token = iterator.next();
            if (token.value.equals("'")) {
                if (!processedTokens.isEmpty()) {
                    Token lastToken = processedTokens.getLast();
                    if (token.line == lastToken.line && token.lineOffset == lastToken.lineOffset + 1) {
                        if (lastToken.value.equalsIgnoreCase("u")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                        if (lastToken.value.equalsIgnoreCase("x")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                        if (lastToken.value.equalsIgnoreCase("t")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                        if (lastToken.value.equalsIgnoreCase("d")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                        if (lastToken.value.equalsIgnoreCase("z")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                        if (lastToken.value.equalsIgnoreCase("g")) {
                            this.processSimpleLiteral(iterator, token, processedTokens);
                            continue;
                        }
                    }
                }
                Token compositeToken = this.processString(iterator, token);
                processedTokens.add(compositeToken);
                continue;
            }
            if (token.value.equals("/")) {
                int tokenIndex = iterator.previousIndex();
                LinkedList<Token> commentStartTokens = new LinkedList<Token>();
                commentStartTokens.add(token);
                while (iterator.hasNext()) {
                    Token nextToken = iterator.next();
                    if (nextToken.value.equals("/") && ((Token)commentStartTokens.getLast()).followedBy(nextToken)) {
                        commentStartTokens.add(nextToken);
                        continue;
                    }
                    iterator.previous();
                    break;
                }
                if (commentStartTokens.size() == 1) {
                    processedTokens.add(token);
                    continue;
                }
                if (!this.isComment(tokens.listIterator(tokenIndex), token.line)) continue;
                processedTokens.add(new CommentIdentifier(commentStartTokens));
                int line = token.line;
                while (iterator.hasNext()) {
                    Token nextToken = iterator.next();
                    if (nextToken.line == line) {
                        processedTokens.add(nextToken);
                        continue;
                    }
                    iterator.previous();
                    continue block0;
                }
                continue;
            }
            if (!processedTokens.isEmpty()) {
                Token lastToken = processedTokens.getLast();
                if (lastToken.value.startsWith("*") && lastToken.value.endsWith(".")) {
                    processedTokens.add(token);
                    continue;
                }
                if (token.value.equals(".")) {
                    this.addToComposite(processedTokens, token);
                    continue;
                }
                if (lastToken instanceof CompositeToken && ((CompositeToken)lastToken).last().value.equals(".")) {
                    this.addToComposite(processedTokens, token);
                    continue;
                }
                processedTokens.add(token);
                continue;
            }
            processedTokens.add(token);
        }
        return processedTokens;
    }

    private boolean isComment(ListIterator<Token> iterator, int line) {
        boolean isComment = false;
        int aposCount = 0;
        int numberPreviousTokens = 0;
        while (iterator.hasPrevious()) {
            Token token = iterator.previous();
            if (token.line != line) break;
            if (token.value == "'") {
                ++aposCount;
            }
            ++numberPreviousTokens;
        }
        if (numberPreviousTokens == 0 || aposCount % 2 == 0) {
            isComment = true;
        }
        return isComment;
    }

    private void processSimpleLiteral(ListIterator<Token> iterator, Token token, LinkedList<Token> processedTokens) {
        CompositeToken composite;
        Token lastToken = processedTokens.getLast();
        if (lastToken instanceof CompositeToken) {
            composite = (CompositeToken)lastToken;
        } else {
            processedTokens.removeLast();
            composite = new CompositeToken(lastToken);
            lastToken = composite;
            processedTokens.add(lastToken);
        }
        composite.add(token);
        while (iterator.hasNext()) {
            token = iterator.next();
            if (token.value.equals("'") && iterator.hasNext()) {
                Token nextToken = iterator.next();
                if (!nextToken.value.equals("'") || !token.followedBy(nextToken)) {
                    composite.add(token);
                    iterator.previous();
                    return;
                }
            }
            composite.add(token);
        }
    }

    private void addToComposite(LinkedList<Token> processedTokens, Token token) {
        Token lastToken = processedTokens.getLast();
        if (!(lastToken instanceof CompositeToken)) {
            processedTokens.removeLast();
            lastToken = new CompositeToken(lastToken);
            processedTokens.add(lastToken);
        }
        ((CompositeToken)lastToken).add(token);
    }

    private Token processString(ListIterator<Token> iterator, Token token) {
        StringToken composite = new StringToken(token);
        while (iterator.hasNext()) {
            int numberSpaces;
            token = iterator.next();
            if (token.value.equals("'") && iterator.hasNext()) {
                Token nextToken = iterator.next();
                if (!nextToken.value.equals("'")) {
                    ((CompositeToken)composite).add(token);
                    iterator.previous();
                    return composite;
                }
            }
            if ((numberSpaces = this.computeNumberSpaces(composite, token)) == 1) {
                ((CompositeToken)composite).add(new SpaceToken(token.offset - 1, token.lineOffset - 1, token.line, " "));
            } else if (numberSpaces > 1) {
                ((CompositeToken)composite).add(new SpaceToken(token.offset - numberSpaces, token.lineOffset - numberSpaces, token.line, StringUtils.repeat((String)" ", (int)numberSpaces)));
            }
            ((CompositeToken)composite).add(token);
        }
        return composite;
    }

    private int computeNumberSpaces(CompositeToken composite, Token token) {
        int numberSpaces = 0;
        if (composite.last().line == token.line) {
            Token lastToken = composite.last();
            int offsetEnd = lastToken.lineOffset + lastToken.value.length();
            numberSpaces = token.lineOffset - offsetEnd;
        } else if (composite.last().value.equals("-")) {
            numberSpaces = token.lineOffset;
        } else {
            composite.last().value.equals("+");
        }
        return numberSpaces;
    }
}

