/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Deque;
import java.util.LinkedList;

public class PositionalReader
extends PushbackReader {
    private static final int CAPACITY = 1000;
    private Deque<Integer> q = new LinkedList<Integer>();
    private int newLine = 10;
    private int offset = -1;
    private int line = 0;
    private int offsetInLine = -1;
    private boolean lastCharNewLine = false;
    private boolean lastOperationUnread = false;

    public PositionalReader(Reader in) {
        super(in, 1000);
    }

    public int line() {
        return this.line;
    }

    public int offsetInLine() {
        return this.offsetInLine;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public int read() throws IOException {
        this.q.addFirst(this.offsetInLine);
        if (this.q.size() > 1000) {
            this.q.removeLast();
        }
        int c = super.read();
        if (this.lastCharNewLine) {
            if (!this.lastOperationUnread) {
                ++this.line;
                this.offsetInLine = -1;
            }
            this.lastCharNewLine = false;
        }
        ++this.offsetInLine;
        ++this.offset;
        if (c == this.newLine) {
            this.lastCharNewLine = true;
        }
        this.lastOperationUnread = false;
        return c;
    }

    @Override
    public void unread(int c) throws IOException {
        this.lastOperationUnread = true;
        if (this.offsetInLine == 0) {
            this.line = Math.max(this.line - 1, 0);
        }
        this.offsetInLine = this.q.pop();
        --this.offset;
        super.unread(c);
    }

    @Override
    public void unread(char[] cbuf) throws IOException {
        this.lastOperationUnread = true;
        this.offset -= cbuf.length;
        char[] cArray = cbuf;
        int n = cbuf.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.offsetInLine == 0) {
                this.line = Math.max(this.line - 1, 0);
            }
            this.offsetInLine = this.q.pop();
            ++n2;
        }
        super.unread(cbuf);
    }
}

