/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.rpg.ast.Token;

public class CompositeToken
extends Token {
    protected LinkedList<Token> tokens = null;
    protected Token singleToken = null;
    protected boolean supportEllipsisContinuation = true;

    public CompositeToken(Token token) {
        super(token.offset, token.lineOffset, token.line, token.value);
        this.singleToken = token;
    }

    public CompositeToken(List<Token> tokens) {
        super(tokens.get((int)0).offset, tokens.get((int)0).lineOffset, tokens.get((int)0).line, tokens.get((int)0).value);
        this.singleToken = tokens.get(0);
        if (tokens.size() > 1) {
            for (Token t : tokens.subList(1, tokens.size())) {
                this.add(t);
            }
        }
    }

    public void add(Token token) {
        if (this.tokens == null) {
            this.tokens = new LinkedList();
            if (this.singleToken != null) {
                this.tokens.add(this.singleToken);
            }
        }
        this.tokens.add(token);
        this.value = String.valueOf(this.value) + token.value;
        if (this.supportEllipsisContinuation && this.value.endsWith("...")) {
            this.value = this.value.substring(0, this.value.length() - 3);
        }
    }

    public List<Token> list() {
        if (this.tokens != null) {
            return Collections.unmodifiableList(this.tokens);
        }
        if (this.singleToken != null) {
            return Collections.unmodifiableList(Arrays.asList(this.singleToken));
        }
        return Collections.emptyList();
    }

    public Token last() {
        if (this.tokens == null) {
            return this.singleToken;
        }
        return this.tokens.getLast();
    }
}

