/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Comment;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.ControlFlow;
import miworkplace.ui.editor.rpg.ast.ControlOption;
import miworkplace.ui.editor.rpg.ast.Element;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.ast.Token;

public class Ast
extends Element {
    final Map<String, Object> symbolMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    final RangeMap<Integer, Procedure> scopes = TreeRangeMap.create();
    private final List<AbstractVariable> variables = new ArrayList<AbstractVariable>();
    private final List<Constant> constants = new ArrayList<Constant>();
    private final List<ControlFlow> controlFlow = new ArrayList<ControlFlow>();
    private final List<File> files = new LinkedList<File>();
    private final List<Subroutine> subroutines = new LinkedList<Subroutine>();
    private final List<Comment> comments = new LinkedList<Comment>();
    private final List<Include> includes = new LinkedList<Include>();
    private final List<Prototype> prototypes = new ArrayList<Prototype>();
    private final List<ControlOption> controlOptions = new ArrayList<ControlOption>();
    private List<Token> tokens;

    public Ast(List<Statement> statements) {
        super(statements);
    }

    public void addSymbol(String name, Object symbol) {
        this.symbolMap.put(name, symbol);
    }

    public Object getSymbol(String name) {
        return this.symbolMap.get(name);
    }

    public boolean isDeclared(Object symbol) {
        for (Object object : this.symbolMap.values()) {
            if (object != symbol) continue;
            return true;
        }
        return false;
    }

    public void addPrototype(Prototype prototype) {
        this.prototypes.add(prototype);
        this.addSymbol(prototype.getName(), prototype);
    }

    public List<Prototype> listPrototypes() {
        return Collections.unmodifiableList(this.prototypes);
    }

    public void addVariable(AbstractVariable v) {
        this.variables.add(v);
        this.addSymbol(v.name, v);
    }

    public List<AbstractVariable> listVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public void addConstant(Constant constant) {
        this.constants.add(constant);
        this.addSymbol(constant.name.toString(), constant);
    }

    public List<Constant> listConstants() {
        return Collections.unmodifiableList(this.constants);
    }

    public List<ControlOption> listControlOptions() {
        return Collections.unmodifiableList(this.controlOptions);
    }

    public void addFile(File f) {
        this.files.add(f);
        this.addSymbol(f.getFilename(), f);
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public void addInclude(Include include) {
        this.includes.add(include);
    }

    public List<File> listFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public void addSubroutine(Subroutine subroutine) {
        this.subroutines.add(subroutine);
        this.addSymbol(subroutine.name().toString(), subroutine);
    }

    public void addControlOption(ControlOption controlOption) {
        this.controlOptions.add(controlOption);
    }

    public ControlOption getControlOption(String name) {
        for (ControlOption co : this.controlOptions) {
            if (!name.equalsIgnoreCase(co.getName())) continue;
            return co;
        }
        return null;
    }

    public List<Subroutine> listSubroutines() {
        return Collections.unmodifiableList(this.subroutines);
    }

    public List<Comment> listComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public List<Token> listTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public List<Include> listIncludes() {
        return Collections.unmodifiableList(this.includes);
    }

    public Procedure getScope(int offset) {
        return (Procedure)this.scopes.get((Comparable)Integer.valueOf(offset));
    }

    public void addControlFlow(ControlFlow pControlFlow) {
        this.controlFlow.add(pControlFlow);
    }

    public List<ControlFlow> getControlFlow() {
        return Collections.unmodifiableList(this.controlFlow);
    }
}

