/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.i18n.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefreshWorkbench
extends Job {
    public static final String REFRESH_KEY = "refresh_check_key";
    public static final String REFRESH_VERSION = "1.26.0.0";
    public static boolean fAlreadyDone = false;
    @Inject
    private UISynchronize uiSync;
    private Debug logger = Debug.getInstance();
    @Inject
    private MApplication fApplicationModel;
    @Inject
    private EModelService fModelService;
    @Inject
    private IWorkbench fWorkbench;

    public RefreshWorkbench() {
        super(Messages.ui_refresh_checker);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.isRefreshNeeded()) {
            return Status.OK_STATUS;
        }
        this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Starting Refresh for version {0}", REFRESH_VERSION));
        this.uiSync.syncExec(() -> {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ui_restart, (String)Messages.ui_miw_was_updated);
            ArrayList children = new ArrayList(this.fApplicationModel.getChildren());
            MWindow window = (MWindow)this.fModelService.createModelElement(MTrimmedWindow.class);
            window.getTags().add("shellTopLevel");
            this.fApplicationModel.getChildren().add(window);
            for (MWindow mWindow : children) {
                mWindow.setVisible(false);
                this.fApplicationModel.getChildren().remove(mWindow);
            }
            this.fModelService.bringToTop((MUIElement)window);
            this.fWorkbench.restart();
        });
        return Status.OK_STATUS;
    }

    private boolean isRefreshNeeded() {
        String refreshVersion;
        block6: {
            block5: {
                refreshVersion = (String)this.fApplicationModel.getPersistedState().get(REFRESH_KEY);
                if (refreshVersion == null) {
                    this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Refresh of the workbench not needed. Current version is {0} Stored version is: {1} (null is new workspace)", REFRESH_VERSION, refreshVersion));
                    refreshVersion = REFRESH_VERSION;
                    this.fApplicationModel.getPersistedState().put(REFRESH_KEY, refreshVersion);
                    return false;
                }
                try {
                    if (!fAlreadyDone) break block5;
                }
                catch (Throwable throwable) {
                    this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Refresh of the workbench not needed. Current version is {0} Stored version is: {1} (null is new workspace)", REFRESH_VERSION, refreshVersion));
                    throw throwable;
                }
                this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Refresh of the workbench not needed. Current version is {0} Stored version is: {1} (null is new workspace)", REFRESH_VERSION, refreshVersion));
                return false;
            }
            fAlreadyDone = true;
            if (!REFRESH_VERSION.equals(refreshVersion)) break block6;
            this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Refresh of the workbench not needed. Current version is {0} Stored version is: {1} (null is new workspace)", REFRESH_VERSION, refreshVersion));
            return false;
        }
        this.fApplicationModel.getPersistedState().put(REFRESH_KEY, REFRESH_VERSION);
        this.logger.info((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Refresh of the workbench not needed. Current version is {0} Stored version is: {1} (null is new workspace)", REFRESH_VERSION, refreshVersion));
        return true;
    }
}

