/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.useraction;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class UserActionCommandBuilder {
    @Inject
    private IWorkspaceStore workspaceStore;

    public String buildCommand(String command, Object selection) {
        Map<String, String> values = this.getVariableValues(selection);
        command = command.replaceAll("\\$\\{connection\\}", StringUtils.defaultString((String)values.get("connection")));
        command = command.replaceAll("\\$\\{library\\}", StringUtils.defaultString((String)values.get("library")));
        command = command.replaceAll("\\$\\{object\\}", StringUtils.defaultString((String)values.get("object")));
        command = command.replaceAll("\\$\\{member\\}", StringUtils.defaultString((String)values.get("member")));
        command = command.replaceAll("\\$\\{path\\}", StringUtils.defaultString((String)values.get("path")));
        command = command.replaceAll("\\$\\{ifspath\\}", StringUtils.defaultString((String)values.get("path")));
        command = command.replaceAll("\\$\\{type\\}", StringUtils.defaultString((String)values.get("type")));
        command = command.replaceAll("\\$\\{attribute\\}", StringUtils.defaultString((String)values.get("attribute")));
        command = command.replaceAll("\\$\\{user\\}", StringUtils.defaultString((String)values.get("user")));
        command = command.replaceAll("\\$\\{streamfile\\}", StringUtils.defaultString((String)values.get("streamfile")));
        command = command.replaceAll("\\$\\{basename\\}", StringUtils.defaultString((String)values.get("basename")));
        return command;
    }

    private Map<String, String> getVariableValues(Object selection) {
        HashMap<String, String> values = new HashMap<String, String>();
        IConnection connection = null;
        IRemoteObject library = null;
        IRemoteObject object = null;
        if (selection instanceof IConnection) {
            connection = (IConnection)selection;
        } else if (selection instanceof SourceMember) {
            SourceMember member = (SourceMember)selection;
            values.put("member", member.getName());
            values.put("path", member.getPath());
            values.put("attribute", member.getSourceType());
            library = this.workspaceStore.getLibrary((IRemoteObject)member);
            connection = member.getConnection();
            object = this.workspaceStore.getSourceFile(connection, member);
        } else if (selection instanceof StreamFile) {
            StreamFile file = (StreamFile)selection;
            values.put("streamfile", file.getName());
            values.put("path", file.getPath());
            values.put("basename", FilenameUtils.getBaseName((String)file.getName()));
            connection = file.getConnection();
        } else if (selection instanceof IRemoteObject) {
            object = (IRemoteObject)selection;
            library = this.workspaceStore.getLibrary(object);
            values.put("path", object.getPath());
        }
        if (connection != null) {
            values.put("connection", connection.getName());
            values.put("user", connection.getSystem().getUserId());
        }
        if (library != null) {
            values.put("library", library.getName());
            if (object == null) {
                values.put("object", library.getName());
                values.put("type", library.getType().abbr());
            }
        }
        if (object != null) {
            values.put("object", object.getName());
            values.put("type", object.getType().abbr());
        }
        return values;
    }
}

