/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import com.remainsoftware.common.util.ServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.ui.compile.CommandContentProposalProvider;
import miworkplace.ui.compile.CompileCommandDialog;
import miworkplace.ui.compile.PlaceholderContentProposalListener;
import miworkplace.ui.compile.RemoteCommandParser;
import miworkplace.ui.compile.ReplacingTextContentAdapter;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.PreferencePage;
import miworkplace.ui.util.Prompter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

class CompilerPreferencePage
extends PreferencePage {
    private PreferenceNode preferenceNode;
    Debug logger = Debug.getInstance();
    private ListViewer compilerList;
    private ICompileSettingsProvider compileSettingsProvider;
    private ICompileSettings current = null;
    private Text compileCommandField;
    private Text compileCommandArgumentsField;
    private CommandContentProposalProvider contentProposalsProvider;
    private Text contentTypeField;
    private IConnectionManager fManager;

    public CompilerPreferencePage(Composite parent, PreferenceNode node, ICompileSettingsProvider compileSettingsProvider) {
        super(parent, 0);
        this.preferenceNode = node;
        this.compileSettingsProvider = compileSettingsProvider;
        this.fManager = (IConnectionManager)ServiceUtils.getOSGiService(((Object)((Object)this)).getClass(), IConnectionManager.class);
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        form.getBody().setLayout((Layout)new GridLayout(1, false));
        form.setText(Messages.ui_pref_compile_commands);
        Label description = toolkit.createLabel(form.getBody(), this.preferenceNode.getDescription(), 64);
        description.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label l1 = toolkit.createLabel(form.getBody(), Messages.ui_pref_compile_label1);
        l1.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.compilerList = new ListViewer(form.getBody(), 516);
        this.compilerList.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.compilerList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.compilerList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICompileSettings) {
                    return ((ICompileSettings)element).getName();
                }
                return super.getText(element);
            }
        });
        this.compilerList.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(200, -1).create());
        this.compilerList.setInput(this.getCompileSettings());
        this.compilerList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    ICompileSettings cs;
                    CompilerPreferencePage.this.storeFieldValues();
                    CompilerPreferencePage.this.current = cs = (ICompileSettings)((IStructuredSelection)event.getSelection()).getFirstElement();
                    CompilerPreferencePage.this.compileCommandField.setText(cs.getCompileCommand());
                    CompilerPreferencePage.this.compileCommandArgumentsField.setText(cs.getCompileArguments() == null ? "" : cs.getCompileArguments());
                    CompilerPreferencePage.this.contentTypeField.setText(String.join((CharSequence)",", cs.getDefaultSourceTypes()));
                    if (StringUtils.isNotBlank((CharSequence)CompilerPreferencePage.this.compileCommandField.getText())) {
                        IConnection activeConnection = CompilerPreferencePage.this.getActiveConnection();
                        CompilerPreferencePage.this.contentProposalsProvider.setCommandParameters(RemoteCommandParser.loadCommandParameters(activeConnection, CompilerPreferencePage.this.compileCommandField.getText()));
                    }
                }
            }
        });
        Composite composite = toolkit.createComposite(form.getBody());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(4).equalWidth(false).create());
        Label l2 = toolkit.createLabel(composite, Messages.ui_pref_compile_label2);
        l2.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        final Button prompt = new Button(composite, 8);
        prompt.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        prompt.setText("Prompt");
        prompt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String cmd = CompilerPreferencePage.this.compileCommandField.getText().toUpperCase();
                IConnection activeConnection = CompilerPreferencePage.this.getActiveConnection();
                if (activeConnection == null) {
                    MessageDialog.openError((Shell)CompilerPreferencePage.this.getShell(), (String)"No active connection", (String)"For prompting an active connection is needed.");
                    return;
                }
                String command = Prompter.prompt(activeConnection, cmd + " " + CompilerPreferencePage.this.compileCommandArgumentsField.getText());
                if (command != null) {
                    CompilerPreferencePage.this.compileCommandArgumentsField.setText(command.trim().replaceFirst(cmd, ""));
                }
                CompilerPreferencePage.this.getShell().forceActive();
            }
        });
        prompt.setEnabled(false);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection activeConnection = CompilerPreferencePage.this.getActiveConnection();
                if (activeConnection == null) {
                    MessageDialog.openConfirm((Shell)CompilerPreferencePage.this.getShell(), (String)"No active connection", (String)"Changing compile settings requires an active connection");
                    return;
                }
                CompileCommandDialog d = new CompileCommandDialog(CompilerPreferencePage.this.getShell(), "Create new Compile Command", "Create a new Compile Command...", activeConnection, CompilerPreferencePage.this.compileSettingsProvider);
                if (d.open() == 0) {
                    CompilerPreferencePage.this.compilerList.setInput(CompilerPreferencePage.this.getCompileSettings());
                    CompilerPreferencePage.this.compilerList.setSelection((ISelection)new StructuredSelection((Object)CompilerPreferencePage.this.compileSettingsProvider.get(d.getResult())), true);
                }
            }
        });
        final Button delete = new Button(composite, 8);
        delete.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        delete.setText("Delete");
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICompileSettings settings;
                if (!CompilerPreferencePage.this.compilerList.getSelection().isEmpty() && (settings = (ICompileSettings)((IStructuredSelection)CompilerPreferencePage.this.compilerList.getSelection()).getFirstElement()).getId().contains(".user.")) {
                    CompilerPreferencePage.this.compileSettingsProvider.remove(settings.getId());
                    CompilerPreferencePage.this.compilerList.setInput(CompilerPreferencePage.this.getCompileSettings());
                    CompilerPreferencePage.this.compilerList.setSelection((ISelection)new StructuredSelection(CompilerPreferencePage.this.compilerList.getElementAt(0)));
                    return;
                }
                CompilerPreferencePage.this.getDisplay().beep();
            }
        });
        delete.setEnabled(false);
        this.compilerList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent pEvent) {
                ICompileSettings settings = (ICompileSettings)((IStructuredSelection)CompilerPreferencePage.this.compilerList.getSelection()).getFirstElement();
                prompt.setEnabled(true);
                if (settings.getId().contains(".user.")) {
                    delete.setEnabled(true);
                } else {
                    delete.setEnabled(false);
                }
            }
        });
        this.compileCommandField = toolkit.createText(form.getBody(), "");
        this.compileCommandField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label l3 = toolkit.createLabel(form.getBody(), "Suffix:");
        l3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.contentTypeField = toolkit.createText(form.getBody(), "");
        this.contentTypeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label l4 = toolkit.createLabel(form.getBody(), Messages.ui_pref_compile_label3);
        l4.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.compileCommandArgumentsField = toolkit.createText(form.getBody(), "", 66);
        this.compileCommandArgumentsField.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 80).create());
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.compileCommandArgumentsField, 16512);
        controlDecoration.setDescriptionText("ctrl+space (type a $ and then ctrl+space for variables)");
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        controlDecoration.setImage(image);
        controlDecoration.show();
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ReplacingTextContentAdapter contentAdapter = new ReplacingTextContentAdapter();
            this.contentProposalsProvider = new CommandContentProposalProvider(contentAdapter);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.compileCommandArgumentsField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.contentProposalsProvider, keyStroke, null);
            contentProposalAdapter.addContentProposalListener((IContentProposalListener)new PlaceholderContentProposalListener(this.compileCommandArgumentsField));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        toolkit.paintBordersFor(form.getBody());
    }

    private IConnection getActiveConnection() {
        return this.fManager.list().stream().filter(conn -> conn.isConnected()).findFirst().orElse(null);
    }

    private List<ICompileSettings> getCompileSettings() {
        ArrayList<ICompileSettings> compileSettings = new ArrayList<ICompileSettings>(this.compileSettingsProvider.list());
        Collections.sort(compileSettings, new Comparator<ICompileSettings>(){

            @Override
            public int compare(ICompileSettings cs1, ICompileSettings cs2) {
                return cs1.getName().compareToIgnoreCase(cs2.getName());
            }
        });
        return compileSettings;
    }

    public void save(IEclipsePreferences preferences) {
        this.storeFieldValues();
        Preferences nodeCompilers = preferences.node("compilers");
        for (ICompileSettings cs : this.getCompileSettings()) {
            Preferences node = nodeCompilers.node(cs.getId());
            node.put("name", cs.getName());
            node.putBoolean("ifs", cs.isIfsSetting());
            node.put("command", cs.getCompileCommand());
            node.put("arguments", cs.getCompileArguments());
            node.put("suffix", String.join((CharSequence)",", cs.getDefaultSourceTypes()));
        }
        try {
            nodeCompilers.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void storeFieldValues() {
        if (this.current != null) {
            this.current.setCompileCommand(this.compileCommandField.getText());
            this.current.setArguments(this.compileCommandArgumentsField.getText());
            if (this.contentTypeField.getText() != null) {
                this.current.setDefaultSourceTypes(Arrays.asList(this.contentTypeField.getText().split(",")));
            } else {
                this.current.setDefaultSourceTypes(Collections.emptyList());
            }
        }
    }

    public boolean canRestore() {
        return true;
    }

    public void restore() {
        MessageDialog m = new MessageDialog(this.getShell(), "Restore defaults", this.getDisplay().getSystemImage(4), "All MiWorkplace compile command customizations will be lost.\n\nUser Defined Compile commands will not be deleted", 5, 0, new String[]{"Cancel", "Restore Defaults"});
        int button = m.open();
        if (button == 1) {
            this.compileSettingsProvider.restoreDefaults();
        }
        this.compilerList.setInput(this.getCompileSettings());
    }

    public boolean isValid() {
        return true;
    }
}

