/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.util.List;
import miworkplace.common.model.TextAttribute;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.ui.pref.api.PreferencePage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.Preferences;

public class ColorsFontsPreferencePage
extends PreferencePage {
    private final String title = Messages.ui_pref_cf_title;
    private ITextAttributeService textAttributeService;
    private TreeViewer viewer;
    private TextAttribute selected = null;

    public ColorsFontsPreferencePage(Composite parent, ITextAttributeService textAttributeService) {
        super(parent, 0);
        this.textAttributeService = textAttributeService;
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(this.title);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        Label l1 = toolkit.createLabel(form.getBody(), Messages.ui_pref_cf_label);
        l1.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l1, 5);
        layoutData.right = new FormAttachment(100);
        final Button edit = toolkit.createButton(form.getBody(), Messages.common_edit, 8);
        edit.setLayoutData((Object)layoutData);
        edit.setEnabled(false);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fontValue = ColorsFontsPreferencePage.this.selected.getValue();
                FontData[] fontList = null;
                if (fontValue != null && !fontValue.isEmpty()) {
                    try {
                        fontList = ColorsFontsPreferencePage.this.deserializeFontData(fontValue);
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
                FontDialog dialog = new FontDialog(ColorsFontsPreferencePage.this.getShell());
                if (fontList != null) {
                    dialog.setFontList(fontList);
                }
                dialog.open();
                fontList = dialog.getFontList();
                if (fontList != null) {
                    String fontData = ColorsFontsPreferencePage.this.serializeFontData(fontList);
                    ColorsFontsPreferencePage.this.selected.setValue(fontData);
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)edit, 0, 128);
        layoutData.bottom = new FormAttachment(60);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.right = new FormAttachment((Control)edit, -15, 16384);
        this.viewer = new TreeViewer(form.getBody(), 516);
        this.viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.viewer.setContentProvider((IContentProvider)new ResourcesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextAttribute) {
                    TextAttribute attribute = (TextAttribute)element;
                    return attribute.getName();
                }
                return super.getText(element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject;
                if (event.getSelection() != null && !event.getSelection().isEmpty() && (selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof TextAttribute) {
                    edit.setEnabled(true);
                    ColorsFontsPreferencePage.this.selected = (TextAttribute)selectedObject;
                    return;
                }
                edit.setEnabled(false);
                ColorsFontsPreferencePage.this.selected = null;
            }
        });
        this.viewer.setInput((Object)this.textAttributeService);
        this.viewer.expandAll();
        toolkit.paintBordersFor(form.getBody());
    }

    private FontData[] deserializeFontData(String value) throws JSONException {
        if (value == null) {
            return null;
        }
        JSONArray array = new JSONArray(value);
        FontData[] fontList = new FontData[array.length()];
        int i = 0;
        while (i < array.length()) {
            fontList[i] = new FontData(array.getString(i));
            ++i;
        }
        return fontList;
    }

    private String serializeFontData(FontData[] fontList) {
        JSONArray fontDataArray = new JSONArray();
        FontData[] fontDataArray2 = fontList;
        int n = fontList.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray2[n2];
            fontDataArray.put((Object)fd.toString());
            ++n2;
        }
        return fontDataArray.toString();
    }

    public boolean isValid() {
        return true;
    }

    public void save(IEclipsePreferences preferences) {
        Preferences node = preferences.node("appearance");
        for (TextAttribute ta : this.textAttributeService.list()) {
            try {
                node.put(ta.getId(), this.serializeTextAttribute(ta));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private String serializeTextAttribute(TextAttribute ta) throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)ta.getId());
        jo.put("value", (Object)ta.getValue());
        return jo.toString();
    }

    class ResourcesContentProvider
    implements ITreeContentProvider {
        private final Object[] NO_OBJECTS = new Object[0];

        ResourcesContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent == ColorsFontsPreferencePage.this.textAttributeService) {
                List categories = ColorsFontsPreferencePage.this.textAttributeService.categories();
                return categories.toArray(new String[categories.size()]);
            }
            if (parent instanceof String) {
                List attributes = ColorsFontsPreferencePage.this.textAttributeService.list(parent.toString());
                return attributes.toArray(new TextAttribute[attributes.size()]);
            }
            return this.NO_OBJECTS;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void dispose() {
        }
    }
}

