/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.QueuedMessage;
import java.util.Enumeration;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.ui.message.JobLogMessage;

public class MessagesLoader
implements Runnable {
    private List<JobLogMessage> messages;
    private IConnection connection;
    private byte[] lastMessageKey;
    private Job job;

    public MessagesLoader(List<JobLogMessage> messages, IConnection connection, Job job, byte[] lastMessageKey) {
        this.messages = messages;
        this.connection = connection;
        this.job = job;
        this.lastMessageKey = lastMessageKey;
    }

    @Override
    public void run() {
        try {
            JobLog log = new JobLog(this.connection.getSystem(), this.job.getName(), this.job.getUser(), this.job.getNumber());
            if (this.lastMessageKey != null) {
                log.setStartingMessageKey(this.lastMessageKey);
            }
            log.addAttributeToRetrieve(301);
            log.addAttributeToRetrieve(404);
            log.addAttributeToRetrieve(704);
            log.addAttributeToRetrieve(705);
            log.addAttributeToRetrieve(703);
            log.addAttributeToRetrieve(706);
            log.addAttributeToRetrieve(702);
            log.addAttributeToRetrieve(1201);
            log.addAttributeToRetrieve(1101);
            log.addAttributeToRetrieve(602);
            log.addAttributeToRetrieve(604);
            log.addAttributeToRetrieve(605);
            log.addAttributeToRetrieve(603);
            log.addAttributeToRetrieve(606);
            log.addAttributeToRetrieve(607);
            log.load();
            Enumeration messagesEnum = log.getMessages();
            while (messagesEnum.hasMoreElements()) {
                QueuedMessage queuedMessage = (QueuedMessage)messagesEnum.nextElement();
                JobLogMessage message = new JobLogMessage();
                message.date = queuedMessage.getDate();
                message.fromProgram = queuedMessage.getFromProgram();
                message.fromModule = queuedMessage.getSendingModuleName();
                message.fromProcedure = queuedMessage.getSendingProcedureName();
                message.fromStatement = queuedMessage.getSendingStatementNumbers();
                message.id = queuedMessage.getID();
                message.message = queuedMessage.getText();
                message.severity = queuedMessage.getSeverity();
                message.type = this.getMessageTypeDescription(queuedMessage.getType());
                message.typeId = queuedMessage.getType();
                message.toProgram = queuedMessage.getReceivingProgramName();
                message.toModule = queuedMessage.getReceivingModuleName();
                message.toProcedure = queuedMessage.getReceivingProcedureName();
                message.toStatement = queuedMessage.getReceiverStatementNumbers();
                message.key = queuedMessage.getKey();
                message.fromJob = queuedMessage.getFromJobName() + "/" + queuedMessage.getUser() + "/" + queuedMessage.getFromJobNumber();
                this.messages.add(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getMessageTypeDescription(int type) {
        switch (type) {
            case 1: {
                return Messages.ui_message_completion;
            }
            case 2: {
                return Messages.ui_message_diagnostic;
            }
            case 4: {
                return Messages.ui_message_info;
            }
            case 5: {
                return Messages.ui_message_inquiry;
            }
            case 6: {
                return Messages.ui_message_senderscopy;
            }
            case 8: {
                return Messages.ui_message_request;
            }
            case 10: {
                return Messages.ui_message_requestwithprompting;
            }
            case 14: {
                return Messages.ui_message_notify;
            }
            case 15: {
                return Messages.ui_message_escape;
            }
            case 16: {
                return Messages.ui_message_notifynothandled;
            }
            case 17: {
                return Messages.ui_message_escapenothandled;
            }
            case 21: {
                return Messages.ui_message_replynotvaliditychecked;
            }
            case 22: {
                return Messages.ui_message_replyvaliditychecked;
            }
            case 23: {
                return Messages.ui_message_replymessagedefaultused;
            }
            case 24: {
                return Messages.ui_message_replysystemdefaultused;
            }
            case 25: {
                return Messages.ui_message_replyfromsystemreplylist;
            }
        }
        return "";
    }
}

