/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import com.ibm.as400.access.Job;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.ui.message.JobLogMessage;
import miworkplace.ui.message.MessageRetrievalInfoProvider;
import miworkplace.ui.message.MessagesLoader;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.log.LogService;

public class MessageRetrieverThread
extends Thread {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnection connection;
    @Inject
    private Job job;
    @Inject
    private MessageRetrievalInfoProvider infoProvider;
    @Inject
    @Named(value="retrieval.interval")
    private Integer retrievalInterval = 10;
    private boolean running = true;

    public MessageRetrieverThread() {
        this.setName("MessageRetriever");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (!this.running) {
                    return;
                }
                ArrayList<JobLogMessage> messages = new ArrayList<JobLogMessage>();
                byte[] lastMessageKey = this.infoProvider.getLastMessageKey();
                MessagesLoader messagesLoader = new MessagesLoader(messages, this.connection, this.job, lastMessageKey);
                messagesLoader.run();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("job", this.job.toString());
                data.put("connection", this.connection.getName());
                data.put("messages", messages);
                this.eventBroker.send("miworkplace/ui/jobs/messages/retrieved", data);
                try {
                    MessageRetrieverThread.sleep(this.retrievalInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.log(3, "MessageRetriever thread interrupted.");
                }
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Error fetching messages for job " + this.job.toString(), (Throwable)e);
        }
    }

    public void end() {
        this.running = false;
        this.interrupt();
    }
}

