/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IActiveConnectionService;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.service.log.LogService;

public class ShowSpooledFilesHandler {
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected LogService logger;
    @Inject
    protected IActiveConnectionService activeConnService;
    @Inject
    protected IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        boolean atLeastOneJobSelected = false;
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof Job)) continue;
            atLeastOneJobSelected = true;
            break;
        }
        return atLeastOneJobSelected;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection, EPartService partService, IEclipseContext context, ECommandService commandService) {
        Job job = this.getSelectedJob(selection);
        if (job == null) {
            return;
        }
        IConnection connection = this.activeConnService.getLastUsedActiveConnection();
        if (connection == null) {
            return;
        }
        ParameterizedCommand command = commandService.createCommand("miworkplace.ui.command.showview.spools", null);
        try {
            command.executeWithChecks(null, null);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not active spooled file view.", (Throwable)e);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("connection", connection.getName());
        data.put("jobname", job.getName());
        data.put("jobnumber", job.getNumber());
        data.put("username", job.getUser());
        this.eventBroker.send("miworkplace/spools/job", data);
    }

    private Job getSelectedJob(IStructuredSelection selection) {
        for (Object object : selection) {
            if (!(object instanceof Job)) continue;
            return (Job)object;
        }
        return null;
    }
}

