/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Base64;
import java.util.Collection;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.message.MessageView;
import miworkplace.ui.message.ShowMessageViewJob;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.service.log.LogService;

public class ShowMessagesHandler {
    public static final String COMMAND_ID = "miworkplace.ui.command.message.show";
    @Inject
    protected LogService logger;
    @Inject
    protected IActiveConnectionService activeConnService;
    @Inject
    protected IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        boolean atLeastOneJobSelected = false;
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof Job)) continue;
            Job job = (Job)selectedElement;
            try {
                if (!job.getStatus().equals("*ACTIVE")) continue;
                atLeastOneJobSelected = true;
                break;
            }
            catch (Exception exception) {}
        }
        return atLeastOneJobSelected;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection, EPartService partService, IEclipseContext context) {
        Job job = this.getSelectedJob(selection);
        if (job == null) {
            return;
        }
        IConnection connection = this.activeConnService.getLastUsedActiveConnection();
        if (connection == null) {
            return;
        }
        byte[] lastMessageKey = null;
        MPart part = this.getPart(connection, job, partService);
        if (part != null && part.getObject() != null) {
            lastMessageKey = ((MessageView)part.getObject()).getLastMessageKey();
            partService.showPart(part, EPartService.PartState.ACTIVATE);
        } else {
            ShowMessageViewJob loader = new ShowMessageViewJob(connection, job, lastMessageKey);
            ContextInjectionFactory.inject((Object)((Object)loader), (IEclipseContext)context);
            loader.setRule(new ConnectionRule(connection.getName()));
            loader.schedule();
        }
    }

    private Job getSelectedJob(IStructuredSelection selection) {
        for (Object object : selection) {
            if (!(object instanceof Job)) continue;
            return (Job)object;
        }
        return null;
    }

    protected MPart getPart(IConnection connection, Job job, EPartService partService) {
        String inputUri = this.composeInputUri(connection, job);
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(inputUri) || part.getObject() == null || !(part.getObject() instanceof MessageView)) continue;
            return part;
        }
        return null;
    }

    protected String encode(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes());
    }

    private String composeInputUri(IConnection connection, Job job) {
        return "job://" + this.encode(connection.getName()) + "/" + job.toString();
    }
}

