/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.api.JobFilter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefreshHandler {
    @Inject
    private IJobFilterService filterService;
    @Inject
    private IActiveConnectionService fACService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        return this.fACService.getLastUsedActiveConnection() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, MUIElement item) {
        if (item instanceof MToolItem) {
            this.updateSelectedFilters(shell, this.filterService.listJobFilters(this.fACService.getLastUsedActiveConnection()));
        } else {
            this.updateSelectedFilters(shell, selection.toList());
        }
    }

    private void updateSelectedFilters(Shell shell, final List<?> filters) {
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                filters.forEach(filter -> {
                    if (filter instanceof JobFilter) {
                        RefreshHandler.this.filterService.refresh((JobFilter)filter);
                    }
                });
            }
        });
    }
}

