/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.api.JobFilter;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.jobs.EditJobFilterDialogHandler;
import miworkplace.ui.jobs.JobToolTipTextComposer;
import miworkplace.ui.jobs.ShowJobFilterDialogHandler;
import miworkplace.ui.jobs.ShowSpooledFilesHandler;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;

public class JobView {
    public static final String EVENT_COLLAPSE_ALL = "miworkplace/ui/jobs/collapse/all";
    public static final String EVENT_EXPAND_ALL = "miworkplace/ui/jobs/expand/all";
    private final String JOBFILTER_MENU = "miworkplace.ui.menu.popup.jobfilter";
    private final String JOB_MENU = "miworkplace.ui.menu.popup.jobs";
    private final String ROOT_MENU = "miworkplace.ui.menu.popup.jobs.root";
    @Inject
    private IResourcePool imagePool;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IActiveConnectionService activeConnService;
    @Inject
    private IJobFilterService jobFilterService;
    @Inject
    private EPartService fPartService;
    @Inject
    private IEclipseContext fContext;
    private Composite parent;
    private TreeViewer viewer;
    private CellLabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private StackLayout mainLayout;
    private Composite noConnectionPanel;
    private Composite noJobsConfiguredPanel;
    private Composite noConnectionSelectedPanel;
    private Composite noActiveConnectionPanel;

    @PostConstruct
    public void postConstruct(Composite parent, final EMenuService menuService, MPart part) {
        this.parent = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.labelProvider = new JobLabelProvider();
        this.contentProvider = new JobContentProvider();
        this.noConnectionPanel = this.buildNoConnectionLabel(parent);
        this.noJobsConfiguredPanel = this.buildNoJobsConfiguredPanel(parent);
        this.noConnectionSelectedPanel = this.buildNoConnectionSelectedLabel(parent);
        this.noActiveConnectionPanel = this.buildNoActiveConnectionLabel(parent);
        this.viewer = new TreeViewer(parent, 770);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setFilters(new ViewerFilter[]{new JobViewerFilter()});
        this.viewer.setInput((Object)this.jobFilterService);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((ESelectionService)JobView.this.fContext.get(ESelectionService.class)).setSelection((Object)event.getSelection());
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection selection = (ITreeSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof JobFilter) {
                        menuService.registerContextMenu((Object)JobView.this.viewer.getControl(), "miworkplace.ui.menu.popup.jobfilter");
                    } else if (element instanceof Job) {
                        menuService.registerContextMenu((Object)JobView.this.viewer.getControl(), "miworkplace.ui.menu.popup.jobs");
                    } else {
                        menuService.registerContextMenu((Object)JobView.this.viewer.getControl(), "miworkplace.ui.menu.popup.jobs.root");
                    }
                } else {
                    menuService.registerContextMenu((Object)JobView.this.viewer.getControl(), "miworkplace.ui.menu.popup.jobs.root");
                }
            }
        });
        this.viewer.addDoubleClickListener(pEvent -> this.doubleClick());
        this.showComponents();
        int retrievalInterval = this.applicationPreferences.getInt("miworkplace.ui.jobs.interval", 5);
        this.jobFilterService.setRetrievalInterval(retrievalInterval);
        if (this.applicationPreferences.getBoolean("miworkplace.ui.jobs.start", false)) {
            this.jobFilterService.startRetrieval();
        }
        WorkspaceUtil.setHelp((Widget)parent, "miworkplace.help.MIW: Jobs");
        menuService.registerContextMenu((Object)this.viewer.getControl(), "miworkplace.ui.menu.popup.jobs.root");
    }

    private void createInitialFilters(IConnection pConnection, IJobFilterService pJobFilterService) {
        if (pJobFilterService.listJobFilters(pConnection).isEmpty()) {
            JobFilter filter = new JobFilter();
            filter.connectionName = pConnection.getName();
            filter.selectionCurrentUserName = pConnection.getUsername();
            filter.selectionStatus = JobFilter.JobStatus.Active;
            filter.selectionSubsystem = "QUSRWRK";
            filter.name = Messages.ui_jobs_filter_my_srv_job;
            pJobFilterService.addJobFilter(filter);
            filter = new JobFilter();
            filter.connectionName = pConnection.getName();
            filter.selectionUserName = pConnection.getUsername();
            filter.selectionStatus = JobFilter.JobStatus.Active;
            filter.selectionJobType = JobFilter.JobType.Interactive;
            filter.name = Messages.ui_jobs_filter_my_int_jobs;
            pJobFilterService.addJobFilter(filter);
        }
    }

    private void doubleClick() {
        block7: {
            Object element = this.viewer.getStructuredSelection().getFirstElement();
            if (element instanceof Job) {
                try {
                    if (((Job)element).getStatus().equals("*ACTIVE")) {
                        WorkspaceUtil.runCommand("miworkplace.ui.command.message.show", this.fContext);
                        break block7;
                    }
                    ShowSpooledFilesHandler handler = (ShowSpooledFilesHandler)ContextInjectionFactory.make(ShowSpooledFilesHandler.class, (IEclipseContext)this.fContext);
                    ECommandService cmdService = (ECommandService)this.fContext.get(ECommandService.class);
                    handler.execute((IStructuredSelection)this.viewer.getStructuredSelection(), this.fPartService, this.fContext, cmdService);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (element instanceof JobFilter) {
                EditJobFilterDialogHandler handler = (EditJobFilterDialogHandler)ContextInjectionFactory.make(EditJobFilterDialogHandler.class, (IEclipseContext)this.fContext);
                handler.execute(this.viewer.getControl().getShell(), this.fContext, (IStructuredSelection)this.viewer.getStructuredSelection());
            } else {
                ShowJobFilterDialogHandler handler = (ShowJobFilterDialogHandler)ContextInjectionFactory.make(ShowJobFilterDialogHandler.class, (IEclipseContext)this.fContext);
                handler.execute(this.viewer.getControl().getShell(), this.fContext);
            }
        }
    }

    private void showComponents() {
        if (this.activeConnService.getLastUsedActiveConnection() == null) {
            this.mainLayout.topControl = this.noConnectionSelectedPanel;
        } else if (!this.activeConnService.getLastUsedActiveConnection().isConnected()) {
            this.mainLayout.topControl = this.noActiveConnectionPanel;
        } else if (this.connectionManager.list().isEmpty()) {
            this.mainLayout.topControl = this.noConnectionPanel;
        } else {
            if (this.jobFilterService.listJobFilters(this.activeConnService.getLastUsedActiveConnection()).isEmpty()) {
                this.createInitialFilters(this.activeConnService.getLastUsedActiveConnection(), this.jobFilterService);
            }
            this.mainLayout.topControl = this.viewer.getControl();
            this.viewer.refresh();
        }
        this.parent.layout();
    }

    @Focus
    public void onFocus() {
        this.viewer.getControl().setFocus();
    }

    @Inject
    @Optional
    public void notifiedJobFilterAdded(@UIEventTopic(value="miworkplace/ui/jobs/filter/added") Event event) {
        this.showComponents();
    }

    @Inject
    @Optional
    public void notifiedJobFilterRemoved(@UIEventTopic(value="miworkplace/ui/jobs/filter/removed") Event event) {
        this.showComponents();
    }

    @Inject
    @Optional
    public void notifiedJobFilterEdited(@UIEventTopic(value="miworkplace/ui/jobs/filter/edited") Event event) {
        JobFilter filter = (JobFilter)event.getProperty("filter");
        this.viewer.update((Object)filter, null);
    }

    @Inject
    @Optional
    public void notifiedJobListRetrieved(@UIEventTopic(value="miworkplace/ui/jobs/listretrieved") Event event) {
        Object filter = event.getProperty("filter");
        Object[] expandedElements = this.viewer.getExpandedElements();
        TreePath[] expandedTreePaths = this.viewer.getExpandedTreePaths();
        this.viewer.refresh(filter);
        this.viewer.setExpandedElements(expandedElements);
        this.viewer.setExpandedTreePaths(expandedTreePaths);
    }

    @Inject
    @Optional
    public void notifiedConnection(@UIEventTopic(value="miworkplace/connection/*") Event event) {
        try {
            if (event.getTopic().equals("miworkplace/connection/connected")) {
                this.showComponents();
            } else if (event.getTopic().equals("miworkplace/connection/changed")) {
                this.viewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/created")) {
                if (this.connectionManager.list().size() == 1) {
                    this.showComponents();
                }
                Object[] expandedElements = this.viewer.getExpandedElements();
                TreePath[] expandedTreePaths = this.viewer.getExpandedTreePaths();
                this.viewer.refresh();
                this.viewer.setExpandedElements(expandedElements);
                this.viewer.setExpandedTreePaths(expandedTreePaths);
            } else if (event.getTopic().equals("miworkplace/connection/deleted")) {
                if (this.connectionManager.list().isEmpty()) {
                    this.showComponents();
                }
                this.viewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/disconnected")) {
                this.viewer.refresh();
            }
        }
        catch (SWTException sWTException) {}
    }

    @Inject
    @Optional
    private void notifiedUsedConnectionChanged(@UIEventTopic(value="miworkplace/services/last_used_connection") IConnection connection) {
        this.showComponents();
    }

    @Inject
    @Optional
    private void notifiedJobChanged(@UIEventTopic(value="miworkplace/ui/jobs/job/changed") Job[] jobs) {
        this.viewer.update((Object[])jobs, null);
    }

    @Inject
    @Optional
    private void notifiedCollapseAll(@UIEventTopic(value="miworkplace/ui/jobs/collapse/all") Event event) {
        this.viewer.collapseAll();
    }

    @Inject
    @Optional
    private void notifiedExpandAll(@UIEventTopic(value="miworkplace/ui/jobs/expand/all") Event event) {
        this.viewer.expandAll();
    }

    private Composite buildNoConnectionLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.common_noconns);
        return form;
    }

    private Composite buildNoJobsConfiguredPanel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_jobs_noneConfigured);
        return form;
    }

    private Composite buildNoConnectionSelectedLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.common_noconnselected);
        return form;
    }

    private Composite buildNoActiveConnectionLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.common_noactiveconn);
        return form;
    }

    class JobContentProvider
    implements ITreeContentProvider {
        private Object[] noObjects = new Object[0];

        JobContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == JobView.this.jobFilterService) {
                List<JobFilter> jobFilter = JobView.this.jobFilterService.listJobFilters();
                return jobFilter.toArray(new JobFilter[jobFilter.size()]);
            }
            if (inputElement instanceof JobFilter) {
                List<Job> jobs = JobView.this.jobFilterService.listJobs((JobFilter)inputElement);
                if (jobs == null) {
                    return this.noObjects;
                }
                Collections.sort(jobs, new Comparator<Job>(){

                    @Override
                    public int compare(Job j1, Job j2) {
                        return j1.toString().compareTo(j2.toString());
                    }
                });
                return jobs.toArray(new Job[jobs.size()]);
            }
            return this.noObjects;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getElements(element).length > 0;
        }
    }

    class JobLabelProvider
    extends StyledCellLabelProvider {
        private static final String SPC = " ";
        private static final String SPCC = ", ";
        private static final String ES = "";

        JobLabelProvider() {
        }

        public boolean isOwnerDrawEnabled() {
            return true;
        }

        public void update(ViewerCell cell) {
            block12: {
                Object element = cell.getElement();
                cell.setText(element.toString());
                if (element instanceof Job) {
                    Job job = (Job)element;
                    try {
                        if (job.getStatus().equals("*ACTIVE")) {
                            cell.setImage(JobView.this.imagePool.getImageUnchecked("IMAGE_JOB_RUNNING"));
                            try {
                                String name = element.toString();
                                String text = MessageFormat.format("{0} - ({1})", name, job.getStringValue(101));
                                cell.setText(text);
                                StyleRange[] sra = new StyleRange[]{new StyleRange(name.length() + 1, cell.getText().length(), null, null, 2)};
                                cell.setStyleRanges(sra);
                            }
                            catch (Exception exception) {}
                            break block12;
                        }
                        if (job.getStatus().equals("*OUTQ")) {
                            cell.setImage(JobView.this.imagePool.getImageUnchecked("IMAGE_JOB_ENDED"));
                            break block12;
                        }
                        if (!job.getStatus().equals("*JOBQ")) break block12;
                        cell.setImage(JobView.this.imagePool.getImageUnchecked("IMAGE_JOB_QUEUED"));
                        try {
                            String name = element.toString();
                            String text = MessageFormat.format("{0} - ({1})", name, job.getStringValue(1903));
                            cell.setText(text);
                            StyleRange[] sra = new StyleRange[]{new StyleRange(name.length() + 1, cell.getText().length(), null, null, 2)};
                            cell.setStyleRanges(sra);
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {}
                } else if (element instanceof JobFilter) {
                    cell.setImage(JobView.this.imagePool.getImageUnchecked("IMAGE_JOBS"));
                    cell.setText(this.getText((JobFilter)element));
                    String name = ((JobFilter)element).toString();
                    StyleRange[] sra = new StyleRange[]{new StyleRange(0, name.length(), null, null, 1), new StyleRange(name.length() + 1, cell.getText().length(), null, null, 2)};
                    cell.setStyleRanges(sra);
                } else {
                    cell.setText(element.toString());
                }
            }
        }

        private String getText(JobFilter pJobFilter) {
            try {
                return pJobFilter.toString() + "  -  (" + ((String)(pJobFilter.selectionJobName == null ? ES : Messages.ui_jobs_filter_jobname + SPC + pJobFilter.selectionJobName + SPCC) + (String)(pJobFilter.selectionUserName == null ? ES : Messages.ui_jobs_filter_username + SPC + pJobFilter.selectionUserName + SPCC) + (String)(pJobFilter.selectionCurrentUserName == null ? ES : Messages.ui_jobs_filter_curr_user + SPC + pJobFilter.selectionCurrentUserName + SPCC) + (String)(pJobFilter.selectionJobQueue == null ? ES : Messages.ui_jobs_filter_jobqueue + SPC + pJobFilter.selectionJobQueue + SPCC) + (String)(pJobFilter.selectionSubsystem == null ? ES : Messages.ui_jobs_filter_subsystem + SPC + pJobFilter.selectionSubsystem + SPCC) + (String)(pJobFilter.selectionJobType == null ? ES : Messages.ui_jobs_filter_jobtype + SPC + String.valueOf((Object)pJobFilter.selectionJobType) + SPCC) + (String)(pJobFilter.selectionStatus == null ? ES : Messages.ui_jobs_filter_jobstatus + SPC + String.valueOf((Object)pJobFilter.selectionStatus) + SPCC) + (String)(pJobFilter.selectionJobQueueStatus == null ? ES : Messages.ui_jobs_filter_jobqueuestatus + SPC + String.valueOf((Object)pJobFilter.selectionJobQueueStatus))).trim().replaceFirst("(.*),", "$1") + ")";
            }
            catch (Exception exception) {
                return pJobFilter.toString();
            }
        }

        public String getToolTipText(Object element) {
            IConnection connection = JobView.this.activeConnService.getLastUsedActiveConnection();
            if (element instanceof Job) {
                return JobToolTipTextComposer.createToolTipText(connection, (Job)element);
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return -1;
        }
    }

    class JobViewerFilter
    extends ViewerFilter {
        JobViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IConnection connection = JobView.this.activeConnService.getLastUsedActiveConnection();
            if (connection == null) {
                return false;
            }
            if (element instanceof JobFilter) {
                return ((JobFilter)element).connectionName.equals(connection.getName());
            }
            if (element instanceof Job) {
                return ((JobFilter)parentElement).connectionName.equals(connection.getName());
            }
            return false;
        }
    }
}

