/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import miworkplace.common.debug.Debug;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class JobHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker broker;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return this.getValidJobs(selection).size() > 0;
    }

    private List<Job> getValidJobs(IStructuredSelection selection) {
        ArrayList<Job> result = new ArrayList<Job>();
        try {
            for (Object object : selection.toList()) {
                Job job;
                if (!(object instanceof Job) || !this.test(job = (Job)object)) continue;
                result.add(job);
            }
        }
        catch (Exception exception) {}
        return result;
    }

    protected abstract boolean test(Job var1) throws Exception;

    protected abstract void performAction(Job var1) throws Exception;

    protected abstract void failed(Job var1, Exception var2);

    public IEclipsePreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public Debug getDebug() {
        return this.logger;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        ArrayList<Job> payload = new ArrayList<Job>();
        for (Job job : this.getValidJobs(selection)) {
            try {
                this.performAction(job);
                job.loadInformation();
                payload.add(job);
            }
            catch (Exception e) {
                this.failed(job, e);
            }
        }
        if (payload.size() > 0) {
            this.broker.post("miworkplace/ui/jobs/job/changed", (Object)payload.toArray(new Job[0]));
        }
    }
}

