/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.osgi.service.log.LogService;

public class IleDocsLinkHandler {
    private static final String LINK = "http://iledocs.rpgnextgen.com";
    @Inject
    private LogService logger;

    @Execute
    public void execute() {
        this.openUrl(LINK);
    }

    private void openUrl(String url) {
        try {
            if (IleDocsLinkHandler.isLinux()) {
                Runtime.getRuntime().exec("xdg-open " + url);
            } else if (IleDocsLinkHandler.isMac()) {
                Runtime.getRuntime().exec("open " + url);
            } else if (IleDocsLinkHandler.isWindows()) {
                Runtime.getRuntime().exec("cmd /c start " + url);
            } else {
                this.logger.log(2, "Unsupported system for opening url " + url + ". OS: " + System.getProperty("os.name"));
            }
        }
        catch (IOException ioe) {
            this.logger.log(2, "Could not open url " + url + ". Error: " + ioe.getMessage());
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }
}

