/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.wizard;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.wizard.SourceMemberWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SourceMemberWizard
extends Wizard {
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    private SourceMemberWizardPage wizPage;
    private IRemoteObject selectedFile = null;
    private IRemoteObject selectedLibrary = null;
    private IConnection selectedConnection = null;
    private SourceMember member;

    public SourceMemberWizard() {
        this.setWindowTitle(Messages.ui_wizard_member_title);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/icons/wizard.png")));
    }

    @PostConstruct
    public void postConstruct(ESelectionService selectionService) {
        this.updateSelection(selectionService);
    }

    private void updateSelection(ESelectionService selectionService) {
        Object selection = selectionService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object element = ss.getFirstElement();
            if (element instanceof IConnection) {
                this.selectedConnection = (IConnection)element;
            } else if (element instanceof IRemoteObject) {
                IRemoteObject remoteObject = (IRemoteObject)element;
                if (remoteObject.getType() == IRemoteObject.Type.library) {
                    this.selectedLibrary = remoteObject;
                } else {
                    this.selectedLibrary = this.workspaceStore.getLibrary(remoteObject);
                    if (remoteObject.getType() == IRemoteObject.Type.file && remoteObject.getAttribute() == IRemoteObject.Attribute.sourcefile) {
                        this.selectedFile = remoteObject;
                    } else if (remoteObject instanceof SourceMember) {
                        this.selectedFile = this.workspaceStore.getSourceFile(remoteObject.getConnection(), (SourceMember)remoteObject);
                    }
                }
                if (this.selectedLibrary != null) {
                    this.selectedConnection = this.selectedLibrary.getConnection();
                }
            }
        }
    }

    public void addPages() {
        this.wizPage = new SourceMemberWizardPage(this.workspaceStore, this.connectionManager, this.selectedConnection, this.selectedLibrary, this.selectedFile);
        this.addPage((IWizardPage)this.wizPage);
    }

    public boolean performFinish() {
        boolean retVal = true;
        if (this.wizPage.getConnectionName().trim().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_member_noconn);
        } else if (this.wizPage.getLibraryName().trim().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_member_nolib);
        } else if (this.wizPage.getSourceFileName().trim().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_member_nofile);
        } else if (this.wizPage.getMemberName().trim().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_member_nomember);
        }
        if (retVal) {
            IConnection connection = this.connectionManager.get(this.wizPage.getConnectionName());
            if (connection == null) {
                retVal = false;
                this.wizPage.setErrorMessage(Messages.ui_wizard_member_novalidconn);
            } else {
                try {
                    this.connUtil.createSourceMember(connection, this.wizPage.getLibraryName(), this.wizPage.getSourceFileName(), this.wizPage.getMemberName(), this.wizPage.getAttribute().toUpperCase(), this.wizPage.getDescriptionText());
                    QSYSObjectPathName path = new QSYSObjectPathName(this.wizPage.getLibraryName(), this.wizPage.getSourceFileName(), "FILE");
                    this.loadMember(connection, path);
                    this.wizPage.storeValuesInPreferences();
                }
                catch (Exception e) {
                    retVal = false;
                    this.wizPage.setErrorMessage(e.getMessage());
                }
            }
        }
        return retVal;
    }

    private void loadMember(IConnection connection, QSYSObjectPathName pPath) {
        IRemoteObject sourceFile = this.workspaceStore.get(connection, pPath.getPath());
        IFile file = WorkspaceUtil.buildMemberFile(sourceFile, this.wizPage.getMemberName());
        this.member = new SourceMember(connection, (IResource)file, null);
        this.member.setSourceType(this.wizPage.getAttribute().toUpperCase());
        this.workspaceStore.add((IRemoteObject)this.member);
        this.propertiesStore.fetch((IRemoteObject)this.member);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org.eclipse.e4.data", this.member);
        map.put("file", sourceFile);
        this.eventBroker.post("miworkplace/member/created", map);
    }

    public SourceMember getSourceMember() {
        return this.member;
    }
}

