/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.wizard;

import jakarta.inject.Inject;
import java.net.URL;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.wizard.SourceFileWizardPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SourceFileWizard
extends Wizard
implements IWizard {
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    private ESelectionService selectionService;
    private SourceFileWizardPage wizPage;
    private IRemoteObject selectedLibrary = null;
    private IConnection selectedConnection = null;

    public SourceFileWizard() {
        this.setWindowTitle(Messages.ui_wizard_srcf_title);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/icons/wizard.png")));
    }

    private void updateSelection() {
        Object selection = this.getSelectionService().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object element = ss.getFirstElement();
            if (element instanceof IConnection) {
                this.selectedConnection = (IConnection)element;
            } else if (element instanceof IRemoteObject) {
                IRemoteObject remoteObject = (IRemoteObject)element;
                this.selectedLibrary = remoteObject.getType() == IRemoteObject.Type.library ? remoteObject : this.workspaceStore.getLibrary(remoteObject);
                if (this.selectedLibrary != null) {
                    this.selectedConnection = this.selectedLibrary.getConnection();
                }
            }
        }
    }

    public void addPages() {
        this.wizPage = new SourceFileWizardPage(this.workspaceStore, this.connectionManager, this.selectedConnection, this.selectedLibrary);
        this.addPage((IWizardPage)this.wizPage);
    }

    public boolean performFinish() {
        boolean retVal = true;
        if (this.wizPage.getConnectionName().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_srcf_noconn);
        } else if (this.wizPage.getLibraryName().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_srcf_nolib);
        } else if (this.wizPage.getSourceFileName().trim().length() == 0) {
            retVal = false;
            this.wizPage.setErrorMessage(Messages.ui_wizard_srcf_noname);
        }
        if (retVal) {
            IConnection conn = this.connectionManager.get(this.wizPage.getConnectionName());
            if (conn == null) {
                retVal = false;
                this.wizPage.setErrorMessage(Messages.ui_wizard_srcf_invalidconn);
            } else {
                try {
                    this.connUtil.createSourceFile(conn, this.wizPage.getSourceFileName(), this.wizPage.getDescriptionText(), this.wizPage.getLibraryName(), this.wizPage.getSourceLength());
                    IRemoteObject library = this.workspaceStore.getLibrary(conn, this.wizPage.getLibraryName());
                    IResource fileResource = WorkspaceUtil.buildObjectResource(library, this.wizPage.getSourceFileName(), IRemoteObject.Type.file);
                    IRemoteObject object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)IRemoteObject.Type.file, (String)"*FILE", (IRemoteObject.Attribute)IRemoteObject.Attribute.sourcefile, (String)"PF");
                    this.workspaceStore.add(object);
                    this.eventBroker.post("miworkplace/object/created", (Object)object);
                }
                catch (Exception e) {
                    retVal = false;
                    this.wizPage.setErrorMessage(e.getMessage());
                }
            }
        }
        return retVal;
    }

    public ESelectionService getSelectionService() {
        return this.selectionService;
    }

    public void setSelectionService(ESelectionService selectionService) {
        this.selectionService = selectionService;
        this.updateSelection();
    }
}

