/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.explorer.RemoteExplorer;
import miworkplace.ui.util.DirectoryLoader;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class RefreshDirectoryHandler {
    @Inject
    private IEclipseContext context;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        if (selection == null) {
            return false;
        }
        return !selection.isEmpty();
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, EPartService partService) {
        TreePath[] paths;
        RemoteExplorer explorer = (RemoteExplorer)partService.findPart("miworkplace.ui.explorer").getObject();
        long sourceId = explorer.getSourceId();
        TreePath[] treePathArray = paths = selection.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            StreamFile streamFile;
            TreePath path = treePathArray[n2];
            Object object = path.getLastSegment();
            if (object instanceof IConnection && ((IConnection)object).isConnected()) {
                List files = this.workspaceStore.getStreamFilesRecursively((IConnection)object, "/");
                for (IRemoteObject file : files) {
                    this.workspaceStore.remove(file);
                }
                IEclipseContext additionalContext = EclipseContextFactory.create();
                IConnection connection = (IConnection)object;
                additionalContext.set(IConnection.class, (Object)connection);
                additionalContext.set("miworkplace.ui.source.id", (Object)sourceId);
                Object loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
                loader.setRule(new ConnectionRule(connection.getName()));
                loader.schedule();
            } else if (object instanceof StreamFile && ((StreamFile)object).getConnection().isConnected() && (streamFile = (StreamFile)object).isDirectory()) {
                List files = this.workspaceStore.getStreamFilesRecursively(streamFile.getConnection(), streamFile.getPath());
                for (IRemoteObject file : files) {
                    this.workspaceStore.remove(file);
                }
                streamFile.setChildrenLoaded(false);
                IEclipseContext additionalContext = EclipseContextFactory.create();
                IConnection connection = streamFile.getConnection();
                additionalContext.set(IConnection.class, (Object)connection);
                additionalContext.set(StreamFile.class, (Object)streamFile);
                additionalContext.set("miworkplace.ui.source.id", (Object)sourceId);
                DirectoryLoader loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
                loader.setRule(new ConnectionRule(connection.getName()));
                loader.schedule();
            }
            ++n2;
        }
    }
}

