/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.services.api.ILastUsedEditorService;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.osgi.service.log.LogService;

public class ProxyOpenStreamFileReadOnlyHandler {
    @Inject
    private LogService logger;
    @Inject
    private ILastUsedEditorService lastUsedEditorService;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Optional @Named(value="miworkplace.ui.editor.command.parameter.selection") String ifsPath, @Optional @Named(value="miworkplace.ui.editor.command.parameter.connection") String connectionName) {
        this.execute(ifsPath, connectionName, null);
    }

    public void execute(@Optional @Named(value="miworkplace.ui.editor.command.parameter.selection") String ifsPath, @Optional @Named(value="miworkplace.ui.editor.command.parameter.connection") String connectionName, @Optional String commandId) {
        if (ifsPath != null) {
            IConnection connection = this.connectionManager.get(connectionName);
            WorkspaceUtil.load(connection, ifsPath);
            StreamFile streamFile = (StreamFile)this.workspaceStore.get(connection, ifsPath);
            if (commandId == null || commandId.isEmpty()) {
                commandId = this.getCommandId(streamFile);
            }
            this.delegate(streamFile, commandId);
            return;
        }
        Object selection = this.selectionService.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        for (Object obj : (IStructuredSelection)selection) {
            StreamFile streamFile;
            if (!(obj instanceof StreamFile) || !(streamFile = (StreamFile)obj).isFile()) continue;
            if (commandId == null || commandId.isEmpty()) {
                commandId = this.getCommandId(streamFile);
            }
            this.delegate(streamFile, commandId);
        }
    }

    private String getCommandId(StreamFile streamFile) {
        String commandId = this.lastUsedEditorService.getCommandId(streamFile.getConnection().getName(), streamFile.getPath());
        if (commandId == null) {
            List contentTypes = this.contentTypeRegistry.getContentType((IRemoteObject)streamFile);
            commandId = contentTypes.isEmpty() ? "miworkplace.ui.editor.command.ifs.open.with.default" : (contentTypes.size() == 1 ? ((ContentType)contentTypes.get(0)).getIfsCommandId() : this.getNonDefaultCommandId(contentTypes));
        }
        return commandId;
    }

    private void delegate(StreamFile streamFile, String commandId) {
        this.logger.log(4, "Using command id " + commandId + " for opening " + streamFile.getName());
        Command command = this.commandService.getCommand(commandId);
        if (command.isDefined()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("miworkplace.ui.editor.command.parameter.selection", streamFile.getPath());
            parameters.put("miworkplace.ui.editor.command.parameter.connection", streamFile.getConnection().getName());
            parameters.put("miworkplace.ui.editor.command.parameter.readonly", Boolean.TRUE.toString());
            ParameterizedCommand cmd = this.commandService.createCommand(commandId, parameters);
            if (this.handlerService.canExecute(cmd)) {
                this.handlerService.executeHandler(cmd);
            } else {
                this.logger.log(1, "Cannot execute command open stream file with command " + commandId + ". CanExecute check failed.");
            }
        } else {
            this.logger.log(1, "Command for opening stream file is not defined. Command Id: " + commandId);
        }
    }

    private String getNonDefaultCommandId(List<ContentType> contentTypes) {
        for (ContentType ct : contentTypes) {
            if (ct.getId().equals("miworkplace.ui.editor.default")) continue;
            return ct.getIfsCommandId();
        }
        if (contentTypes.isEmpty()) {
            return null;
        }
        return contentTypes.get(0).getIfsCommandId();
    }
}

