/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.Commands;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.services.api.ILastUsedEditorService;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.osgi.service.log.LogService;

public class ProxyOpenMemberHandler {
    @Inject
    private LogService logger;
    @Inject
    private ILastUsedEditorService lastUsedEditorService;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Optional @Named(value="miworkplace.ui.editor.command.parameter.selection") String memberPath, @Optional @Named(value="miworkplace.ui.editor.command.parameter.connection") String connectionName) {
        if (memberPath != null) {
            IConnection connection = this.connectionManager.get(connectionName);
            WorkspaceUtil.load(connection, memberPath);
            SourceMember member = (SourceMember)this.workspaceStore.get(connection, memberPath);
            String commandId = this.getCommandId(member);
            this.delegate(member, commandId);
        } else {
            Object selection = this.selectionService.getSelection();
            if (selection != null) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object obj : ss) {
                    if (!(obj instanceof SourceMember)) continue;
                    SourceMember member = (SourceMember)obj;
                    String commandId = this.getCommandId(member);
                    this.delegate(member, commandId);
                }
            }
        }
    }

    private String getCommandId(SourceMember member) {
        String commandId = this.lastUsedEditorService.getCommandId(member.getConnection().getName(), member.getPath());
        if (commandId == null) {
            List contentTypes = this.contentTypeRegistry.getContentType((IRemoteObject)member);
            commandId = contentTypes.isEmpty() ? Commands.OpenSourceMember.id() : (contentTypes.size() == 1 ? ((ContentType)contentTypes.get(0)).getCommandId() : this.getNonDefaultCommandId(contentTypes));
        }
        return commandId;
    }

    private void delegate(SourceMember member, String commandId) {
        Command command = this.commandService.getCommand(commandId);
        if (command.isDefined()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("miworkplace.ui.editor.command.parameter.selection", member.getPath());
            parameters.put("miworkplace.ui.editor.command.parameter.connection", member.getConnection().getName());
            parameters.put("miworkplace.ui.editor.command.parameter.readonly", Boolean.FALSE.toString());
            ParameterizedCommand cmd = this.commandService.createCommand(commandId, parameters);
            if (this.handlerService.canExecute(cmd)) {
                this.handlerService.executeHandler(cmd);
            } else {
                this.logger.log(1, "Cannot execute command open source member with command " + commandId + ". CanExecute check failed.");
            }
        } else {
            this.logger.log(1, "Command for opening source member is not defined. Command Id: " + commandId);
        }
    }

    private String getNonDefaultCommandId(List<ContentType> contentTypes) {
        for (ContentType ct : contentTypes) {
            if (ct.getId().equals("miworkplace.ui.editor.default")) continue;
            return ct.getCommandId();
        }
        if (contentTypes.isEmpty()) {
            return null;
        }
        return contentTypes.get(0).getCommandId();
    }
}

