/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.validator.ObjectNameValidator;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.CopySelection;
import miworkplace.ui.util.MemberLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class PasteMemberHandler {
    private final String ERROR_TITLE = Messages.ui_handler_paste_mbr_title;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionUtilities connUtilFacade;

    public void paste(Shell shell, ESelectionService selectionService, CopySelection copySelection) {
        IConnection connection = this.connectionManager.get(copySelection.getConnectionName());
        Object selection = selectionService.getSelection();
        if (selection == null || ((ISelection)selection).isEmpty()) {
            Notifier.error((String)this.ERROR_TITLE, (String)Messages.ui_handler_paste_mbr_nodest);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object element = ss.getFirstElement();
        IRemoteObject destination = (IRemoteObject)element;
        if (!destination.getConnection().getName().equals(connection.getName())) {
            Notifier.error((String)this.ERROR_TITLE, (String)Messages.ui_handler_paste_mbr_copynotsupported);
            return;
        }
        if (destination.getAttribute() != IRemoteObject.Attribute.sourcefile && destination instanceof SourceMember) {
            destination = this.workspaceStore.getSourceFile(connection, (SourceMember)destination);
        }
        if (!destination.areChildrenLoaded()) {
            MemberLoader loader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context));
            loader.setFile(destination);
            loader.setSourceId(0L);
            loader.setRule(new ConnectionRule(connection.getName()));
            loader.run((IProgressMonitor)new NullProgressMonitor());
        }
        QSYSObjectPathName workPath = new QSYSObjectPathName(destination.getPath());
        for (String ifsPath : copySelection.getValues()) {
            try {
                QSYSObjectPathName name = new QSYSObjectPathName(ifsPath);
                String destMemberName = name.getMemberName();
                workPath.setMemberName(name.getMemberName());
                workPath.setObjectType("MBR");
                IRemoteObject tmpMember = this.workspaceStore.get(connection, workPath.getPath());
                if (tmpMember != null) {
                    MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_paste_mbr_conflict_title, null, String.format(Messages.ui_handler_paste_mbr_conflict_prompt, workPath.getMemberName()), 3, new String[]{Messages.common_rename, Messages.common_overwrite, Messages.common_skip}, 0);
                    int retVal = dialog.open();
                    if (retVal == 0) {
                        List objects = this.workspaceStore.getMembers(destination);
                        List<String> memberNames = this.convertToNames(objects);
                        InputDialog inputDialog = new InputDialog(shell, Messages.ui_handler_paste_mbr_conflict_title, String.format(Messages.ui_handler_paste_mbr_conflict_newname, workPath.getMemberName()), workPath.getMemberName(), (IInputValidator)new ObjectNameValidator(memberNames));
                        if (inputDialog.open() != 0) continue;
                        destMemberName = inputDialog.getValue();
                    } else {
                        if (retVal == 2) continue;
                        if (retVal == 1) {
                            this.connUtilFacade.deleteSourceMember(connection, tmpMember.getPath());
                        }
                    }
                }
                QSYSObjectPathName destPath = new QSYSObjectPathName(destination.getPath());
                destPath.setMemberName(destMemberName);
                destPath.setObjectType("MBR");
                this.connUtilFacade.copyMember(connection, ifsPath, destPath.getPath());
                Notifier.info((String)Messages.ui_handler_paste_mbr_title, (String)String.format(Messages.ui_handler_paste_mbr_success, destMemberName, destPath.getObjectName()));
                SourceMember member = (SourceMember)this.workspaceStore.get(connection, ifsPath);
                this.notifyOthers(connection, ifsPath, destination, destPath, member.getSourceType());
            }
            catch (Exception e) {
                this.logger.log(1, "Could not copy " + ifsPath + " into " + workPath.getPath() + ".", (Throwable)e);
                Notifier.error((String)Messages.ui_handler_paste_mbr_title, (String)String.format(Messages.ui_handler_paste_mbr_error, ifsPath, destination.getPath()));
            }
        }
    }

    private void notifyOthers(IConnection connection, String sourceIfsPath, IRemoteObject destFile, QSYSObjectPathName destPath, String sourceType) {
        IFile file = WorkspaceUtil.buildMemberFile(destFile, destPath.getMemberName());
        SourceMember member = new SourceMember(connection, (IResource)file, null);
        member.setSourceType(sourceType);
        this.workspaceStore.add((IRemoteObject)member);
        IRemoteObject sourceMember = this.workspaceStore.get(connection, sourceIfsPath);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org.eclipse.e4.data", member);
        map.put("file", destFile);
        map.put("source.member", sourceMember);
        this.eventBroker.post("miworkplace/member/created", map);
    }

    private List<String> convertToNames(List<IRemoteObject> objects) {
        ArrayList<String> names = new ArrayList<String>();
        for (IRemoteObject object : objects) {
            names.add(object.getName());
        }
        return names;
    }
}

