/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.ui.explorer.CopySelection;
import miworkplace.ui.explorer.handler.PasteMemberHandler;
import miworkplace.ui.explorer.handler.PasteObjectHandler;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class PasteHandler {
    private PasteMemberHandler pasteMemberHandler;
    private PasteObjectHandler pasteObjectHandler;
    @Inject
    private IEclipseContext context;

    @PostConstruct
    public void postConstruct() {
        this.pasteMemberHandler = (PasteMemberHandler)ContextInjectionFactory.make(PasteMemberHandler.class, (IEclipseContext)this.context);
        this.pasteObjectHandler = (PasteObjectHandler)ContextInjectionFactory.make(PasteObjectHandler.class, (IEclipseContext)this.context);
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, @Named(value="e4ActivePart") MPart part) {
        CopySelection copySelection = (CopySelection)part.getContext().get(CopySelection.class);
        if (copySelection == null) {
            return false;
        }
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof SourceMember) {
            return copySelection.getType() == null;
        }
        if (selectedElement instanceof IRemoteObject) {
            IRemoteObject object = (IRemoteObject)selectedElement;
            if (object.getType() == IRemoteObject.Type.library) {
                return copySelection.getType() != null;
            }
            if (object.getType() == IRemoteObject.Type.file && object.getAttribute() == IRemoteObject.Attribute.sourcefile) {
                return copySelection.getType() == null;
            }
            return false;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="e4ActivePart") MPart part, ESelectionService selectionService) {
        CopySelection copySelection = (CopySelection)part.getContext().get(CopySelection.class);
        if (copySelection == null) {
            return;
        }
        if (copySelection.getType() == null) {
            this.pasteMemberHandler.paste(shell, selectionService, copySelection);
        } else {
            this.pasteObjectHandler.paste(shell, selectionService, copySelection);
        }
    }
}

