/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Named;
import java.util.LinkedList;
import miworkplace.common.model.StreamFile;
import miworkplace.ui.explorer.api.AbstractOpenStreamFileHandler;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;

public class OpenStreamFileHandler
extends AbstractOpenStreamFileHandler {
    private EPartService partService;
    private MApplication application;
    private ESelectionService selectionService;
    private EModelService modelService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(EPartService partService, MApplication application, ESelectionService selectionService, EModelService modelService) {
        this.partService = partService;
        this.application = application;
        this.selectionService = selectionService;
        this.modelService = modelService;
        Object selection = selectionService.getSelection();
        if (selection != null) {
            LinkedList<StreamFile> files = new LinkedList<StreamFile>();
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object obj : ss) {
                if (!(obj instanceof StreamFile)) continue;
                StreamFile file = (StreamFile)obj;
                files.add(file);
            }
            this.open(files);
        }
    }

    @Override
    public String getEditorPartDescriptorId() {
        return "miworkplace.ui.editor.partdescriptor.ifs.default";
    }

    @Override
    protected String getContributionURI() {
        return "bundleclass://miworkplace.ui.editor/miworkplace.ui.editor.ifs.StreamFileEditor";
    }

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Override
    protected EModelService getModelService() {
        return this.modelService;
    }

    @Override
    protected MApplication getApplication() {
        return this.application;
    }

    @Override
    protected ESelectionService getSelectionService() {
        return this.selectionService;
    }
}

