/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.LinkedList;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.SourceMember;
import miworkplace.services.api.ILastUsedEditorService;
import miworkplace.ui.explorer.api.AbstractOpenMemberHandler;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;

public class OpenMemberHandler
extends AbstractOpenMemberHandler {
    @Inject
    private ILastUsedEditorService lastUsedEditorService;
    private EPartService partService;
    private MApplication application;
    private ESelectionService selectionService;
    private EModelService modelService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(EPartService partService, MApplication application, ESelectionService selectionService, EModelService modelService, @Optional @Named(value="miworkplace.ui.editor.command.parameter.selection") String memberPath, @Optional @Named(value="miworkplace.ui.editor.command.parameter.connection") String connectionName, @Optional @Named(value="miworkplace.ui.editor.command.parameter.readonly") String sReadOnly) {
        this.partService = partService;
        this.application = application;
        this.selectionService = selectionService;
        this.modelService = modelService;
        if (memberPath != null) {
            boolean readOnly = sReadOnly == null ? false : Boolean.valueOf(sReadOnly);
            IConnection connection = this.getConnectionManager().get(connectionName);
            SourceMember member = (SourceMember)this.getWorkspaceStore().get(connection, memberPath);
            this.open(Arrays.asList(member), !readOnly);
            this.lastUsedEditorService.setCommandId(member.getConnection().getName(), member.getPath(), "miworkplace.ui.command.open.default");
        } else {
            Object selection = selectionService.getSelection();
            if (selection != null) {
                LinkedList<SourceMember> members = new LinkedList<SourceMember>();
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object obj : ss) {
                    if (!(obj instanceof SourceMember)) continue;
                    SourceMember member = (SourceMember)obj;
                    members.add(member);
                    this.lastUsedEditorService.setCommandId(member.getConnection().getName(), member.getPath(), "miworkplace.ui.command.open.default");
                }
                this.open(members);
            }
        }
    }

    @Override
    protected String getContributionURI() {
        return "bundleclass://miworkplace.ui.editor/miworkplace.ui.editor.RemoteEditor";
    }

    @Override
    public String getEditorPartDescriptorId() {
        return "miworkplace.ui.editor.partdescriptor.default";
    }

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Override
    protected EModelService getModelService() {
        return this.modelService;
    }

    @Override
    protected MApplication getApplication() {
        return this.application;
    }

    @Override
    protected ESelectionService getSelectionService() {
        return this.selectionService;
    }
}

