/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Named;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.dialog.LibraryListDialog;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class DisplayLibraryListHandler {
    private Debug logger = Debug.getInstance();

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        boolean canExecute = false;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection) {
            return ((IConnection)firstElement).isConnected();
        }
        return canExecute;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection, IEclipseContext ctx) {
        IConnection connection = (IConnection)selection.getFirstElement();
        if (connection == null) {
            Notifier.error((String)Messages.ui_handler_dsplibl_title, (String)Messages.ui_handler_dsplibl_noconn);
        } else if (!connection.isConnected()) {
            Notifier.warn((String)Messages.ui_handler_dsplibl_title, (String)Messages.ui_handler_dsplibl_notactive);
        } else {
            try {
                IEclipseContext child = ctx.createChild();
                child.set(IConnection.class, (Object)connection);
                ((LibraryListDialog)((Object)ContextInjectionFactory.make(LibraryListDialog.class, (IEclipseContext)child))).open();
                child.dispose();
            }
            catch (Exception e) {
                Notifier.error((String)"Issue processing library list", (String)e.getMessage());
                this.logger.error(MessageFormat.format("Error showing library list for {0}.", connection.getName()), (Throwable)e);
            }
        }
    }
}

