/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.QueuedMessage;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.dialog.JobLogDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DisplayJobLogHandler {
    @Inject
    private LogService logger;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IActiveConnectionService activeConnectionService;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        boolean canExecute = false;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection) {
            return ((IConnection)firstElement).isConnected();
        }
        return canExecute;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Optional @Named(value="miworkplace.ui.command.joblog.connection") String connectionName) {
        IConnection connection = null;
        connection = connectionName == null ? this.activeConnectionService.getLastUsedActiveConnection() : this.connectionManager.get(connectionName);
        try {
            Collection<String> messages = this.getMessages(connection);
            JobLogDialog dialog = new JobLogDialog(shell, this.getJobName(connection), messages);
            dialog.open();
        }
        catch (Exception e) {
            this.logger.log(1, "Error showing job log for " + connection.getName() + ".", (Throwable)e);
        }
    }

    private Collection<String> getMessages(IConnection connection) throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        SimpleDateFormat timefmt = new SimpleDateFormat("HH:mm:ss");
        Job[] jobs = connection.getSystem().getJobs(2);
        if (jobs.length > 0) {
            JobLog jobLog = jobs[0].getJobLog();
            Enumeration jobe = jobLog.getMessages();
            while (jobe.hasMoreElements()) {
                QueuedMessage msg = (QueuedMessage)jobe.nextElement();
                Calendar date = msg.getDate();
                messages.add(timefmt.format(date.getTime()) + " " + msg.toString());
            }
        }
        return messages;
    }

    private String getJobName(IConnection connection) {
        Job[] jobs = connection.getSystem().getJobs(2);
        if (jobs == null || jobs.length == 0) {
            return null;
        }
        return jobs[0].toString();
    }
}

