/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DeleteObjectHandler {
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private LogService logger;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        this.delete(shell, selection);
    }

    public void delete(Shell shell, ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object element : selection) {
            IRemoteObject object;
            if (element == null || !(element instanceof IRemoteObject) || (object = (IRemoteObject)element).getType() == IRemoteObject.Type.library) continue;
            this.delete(shell, object);
        }
    }

    public void delete(Shell shell, IRemoteObject object) {
        if (object.getType() == IRemoteObject.Type.library) {
            return;
        }
        MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_delete_obj_title, null, String.format(Messages.ui_handler_delete_obj_prompt, object.getName()), 3, new String[]{Messages.common_yes, Messages.common_no}, 0);
        if (dialog.open() == 0) {
            String libraryName = this.workspaceStore.getLibrary(object).getName();
            try {
                this.connUtil.deleteObject(object.getConnection(), libraryName, object.getName(), object.getType().abbr());
                Notifier.info((String)Messages.ui_handler_delete_obj_notify_title, (String)String.format(Messages.ui_handler_delete_obj_success, libraryName, object.getName()));
                this.eventBroker.post("miworkplace/object/deleted", (Object)object);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not delete object.", (Throwable)e);
                Notifier.error((String)Messages.ui_handler_delete_obj_notify_title, (String)String.format(Messages.ui_handler_delete_obj_error, libraryName, object.getName()));
            }
        }
    }
}

