/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.ui.explorer.handler.DeleteMemberHandler;
import miworkplace.ui.explorer.handler.DeleteObjectHandler;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class DeleteHandler {
    @Inject
    private IEclipseContext context;
    private DeleteObjectHandler deleteObjectHandler;
    private DeleteMemberHandler deleteMemberHandler;

    @PostConstruct
    public void postConstruct() {
        this.deleteObjectHandler = (DeleteObjectHandler)ContextInjectionFactory.make(DeleteObjectHandler.class, (IEclipseContext)this.context);
        this.deleteMemberHandler = (DeleteMemberHandler)ContextInjectionFactory.make(DeleteMemberHandler.class, (IEclipseContext)this.context);
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object element : selection) {
            if (element == null) continue;
            if (element instanceof SourceMember) {
                this.deleteMemberHandler.delete(shell, (SourceMember)element);
                continue;
            }
            if (!(element instanceof IRemoteObject)) continue;
            this.deleteObjectHandler.delete(shell, (IRemoteObject)element);
        }
    }
}

