/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.api;

import java.util.HashMap;
import java.util.List;
import miworkplace.common.Commands;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.explorer.api.AbstractOpenHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;

public abstract class AbstractOpenMemberHandler
extends AbstractOpenHandler<SourceMember> {
    public static String getCommandId(SourceMember member, IContentTypeRegistry contentTypeRegistry) {
        String commandId = null;
        List contentTypes = contentTypeRegistry.getContentType((IRemoteObject)member);
        commandId = contentTypes.isEmpty() ? Commands.OpenDefaultEditor.id() : (contentTypes.size() == 1 ? ((ContentType)contentTypes.get(0)).getCommandId() : AbstractOpenMemberHandler.getNonDefaultCommandId(contentTypes));
        if (commandId == null) {
            commandId = Commands.OpenDefaultEditor.id();
        }
        return commandId;
    }

    private static String getNonDefaultCommandId(List<ContentType> contentTypes) {
        for (ContentType ct : contentTypes) {
            if (ct.getId().equals("miworkplace.ui.editor.default")) continue;
            return ct.getCommandId();
        }
        if (contentTypes.isEmpty()) {
            return null;
        }
        return contentTypes.get(0).getCommandId();
    }

    public static void open(SourceMember member, String commandId, boolean readOnly, EHandlerService handlerService, ECommandService commandService, Debug logger) {
        Command command = commandService.getCommand(commandId);
        if (command.isDefined()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("miworkplace.ui.editor.command.parameter.selection", member.getPath());
            parameters.put("miworkplace.ui.editor.command.parameter.connection", member.getConnection().getName());
            parameters.put("miworkplace.ui.editor.command.parameter.readonly", String.valueOf(readOnly));
            ParameterizedCommand cmd = commandService.createCommand(commandId, parameters);
            if (handlerService.canExecute(cmd)) {
                handlerService.executeHandler(cmd);
            } else {
                logger.error((Option)miworkplace.ui.debug.Option.editors, "Cannot execute command open source member with command " + commandId + ". CanExecute check failed.");
            }
        } else {
            logger.error((Option)miworkplace.ui.debug.Option.editors, "Command for opening source member is not defined. Command Id: " + commandId);
        }
    }

    @Override
    protected String composeInputUri(SourceMember member) {
        return "remotefile://" + this.encode(member.getConnection().getName()) + member.getPath();
    }

    @Override
    protected String createPartTooltip(SourceMember member) {
        return member.getConnection().getSystemName() + ":" + member.getPath();
    }

    @Override
    protected String createPartLabel(SourceMember source) {
        return source.getName() + "." + source.getSourceType();
    }

    @Override
    protected String getConnectionName(SourceMember source) {
        return source.getConnection().getName();
    }
}

