/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.api;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ILockService;
import miworkplace.ui.api.IRemoteEditor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public abstract class AbstractOpenHandler<T> {
    private Debug logger = Debug.getInstance();
    @Inject
    private IWorkspaceStore fWorkspaceStore;
    @Inject
    private IConnectionManager fConnectionManager;
    @Inject
    protected ILockService fLockService;

    protected void open(List<T> sources) {
        this.open((T)sources, true);
    }

    public IConnectionManager getConnectionManager() {
        return this.fConnectionManager;
    }

    public IWorkspaceStore getWorkspaceStore() {
        return this.fWorkspaceStore;
    }

    protected void open(List<T> sources, boolean editable) {
        for (T source : sources) {
            if (this.isOpened(source)) {
                this.show(source);
                continue;
            }
            this.open(source, editable);
        }
    }

    protected MPart getPart(T source) {
        String inputUri = this.composeInputUri(source);
        Collection parts = this.getPartService().getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor") || !part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(inputUri) || part.getObject() == null || !(part.getObject() instanceof IRemoteEditor)) continue;
            return part;
        }
        return null;
    }

    protected void show(T source) {
        MPart part = this.getPart(source);
        if (part != null) {
            this.getPartService().showPart(part, EPartService.PartState.ACTIVATE);
        }
    }

    protected boolean isOpened(T source) {
        MPart part = this.getPart(source);
        if (part == null) {
            return false;
        }
        return part.getObject() != null && part.getContext() != null;
    }

    protected void open(T source, boolean editable) {
        String uri = this.composeInputUri(source);
        String name = this.createPartTooltip(source);
        String editorPartDescriptorId = this.getEditorPartDescriptorId();
        if (this.logger.isOn((Option)miworkplace.ui.debug.Option.editors)) {
            this.logger.debug((Option)miworkplace.ui.debug.Option.editors, MessageFormat.format("Using part descriptor id {0}.", editorPartDescriptorId));
        }
        MPart part = this.getPartService().createPart(editorPartDescriptorId);
        part.getProperties().put("miworkplace.editor", Boolean.TRUE.toString());
        part.getProperties().put("miworkplace.editor.inputUri", uri);
        part.getProperties().put("miworkplace.editor.readonly", String.valueOf(!editable));
        part.setLabel(this.createPartLabel(source));
        part.setTooltip(name);
        part.setCloseable(true);
        part.setContributionURI(this.getContributionURI());
        part.getPersistedState().put("miworkplace.editor.inputUri", uri);
        part.getPersistedState().put("miworkplace.editor.connection", this.getConnectionName(source));
        part.getPersistedState().put("miworkplace.editor.readonly", String.valueOf(!editable));
        part.getTags().add("Editor");
        part.getTags().add("removeOnHide");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("org.eclipse.e4.primaryDataStack");
        List stacks = this.getModelService().findElements((MUIElement)this.getApplication(), null, MPartStack.class, tags);
        if (stacks == null || stacks.isEmpty()) {
            tags.clear();
            tags.add("EditorStack");
            stacks = this.getModelService().findElements((MUIElement)this.getApplication(), null, MPartStack.class, tags);
        }
        if (stacks != null && !stacks.isEmpty()) {
            ((MPartStack)stacks.get(0)).getChildren().add(part);
        }
        try {
            this.getPartService().showPart(part, EPartService.PartState.ACTIVATE);
            ((IRemoteEditor)part.getObject()).load();
        }
        catch (Exception e) {
            Notifier.error((String)Messages.mbr_cld_not_open, (String)e.getMessage());
            this.getPartService().hidePart(part, true);
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract String getConnectionName(T var1);

    protected abstract String createPartLabel(T var1);

    public abstract String getEditorPartDescriptorId();

    protected abstract String composeInputUri(T var1);

    protected String encode(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes());
    }

    protected abstract String createPartTooltip(T var1);

    protected abstract String getContributionURI();

    protected abstract EPartService getPartService();

    protected abstract EModelService getModelService();

    protected abstract MApplication getApplication();

    protected abstract ESelectionService getSelectionService();
}

