/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RemoteExplorerContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    @Named(value="miworkplace.ui.source.id")
    private Long sourceId;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof IConnection) {
            return this.connectionManager;
        }
        if (child instanceof SourceMember) {
            SourceMember member = (SourceMember)child;
            return this.workspaceStore.getSourceFile(member.getConnection(), member);
        }
        if (child instanceof IRemoteObject) {
            IRemoteObject object = (IRemoteObject)child;
            if (object.getType() == IRemoteObject.Type.library) {
                return object.getConnection();
            }
            QSYSObjectPathName path = new QSYSObjectPathName(object.getPath());
            return this.workspaceStore.getLibrary(object.getConnection(), path.getLibraryName());
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        this.logger.debug((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("Loading Content for {0}: {1}", parent.getClass().getName(), parent));
        if (parent instanceof IConnectionManager) {
            List connections = this.connectionManager.list();
            Collections.sort(connections, new Comparator<IConnection>(){

                @Override
                public int compare(IConnection c1, IConnection c2) {
                    return c1.getName().compareTo(c2.getName());
                }
            });
            return connections.toArray(new IConnection[connections.size()]);
        }
        if (parent instanceof IConnection) {
            if (((IConnection)parent).isConnected()) {
                List<IRemoteObject> libraries = this.workspaceStore.getLibraries((IConnection)parent);
                libraries = this.filterLibraries(libraries);
                return libraries.toArray(new IRemoteObject[libraries.size()]);
            }
        } else if (parent instanceof IRemoteObject) {
            IRemoteObject remoteObject = (IRemoteObject)parent;
            if (remoteObject.getType() == IRemoteObject.Type.library) {
                if (!remoteObject.areChildrenLoaded()) {
                    System.out.println("load " + parent.toString());
                    ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.eclipseContext));
                    loader.setLibrary(remoteObject);
                    loader.setSourceId(this.getSourceId());
                    loader.setRule(new ConnectionRule(remoteObject.getConnection().getName()));
                    loader.schedule();
                    return new Object[]{Messages.ui_explorer_loading};
                }
                List objects = this.workspaceStore.getObjects(remoteObject);
                Object[] children = objects.toArray(new IRemoteObject[objects.size()]);
                this.logger.debug((Option)miworkplace.ui.debug.Option.rex, MessageFormat.format("Parent: {0} --- Children: {1}", parent, Arrays.toString(children)));
                return children;
            }
            if (remoteObject.getType() == IRemoteObject.Type.file && remoteObject.getAttribute() == IRemoteObject.Attribute.sourcefile) {
                if (!remoteObject.areChildrenLoaded()) {
                    MemberLoader loader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.eclipseContext));
                    loader.setFile((IRemoteObject)parent);
                    loader.setSourceId(this.getSourceId());
                    loader.setRule(new ConnectionRule(remoteObject.getConnection().getName()));
                    loader.schedule();
                    return new Object[]{Messages.ui_explorer_loading};
                }
                List members = this.workspaceStore.getMembers((IRemoteObject)parent);
                return members.toArray(new IRemoteObject[members.size()]);
            }
        }
        return new Object[0];
    }

    private List<IRemoteObject> filterLibraries(List<IRemoteObject> libraries) {
        LinkedList<IRemoteObject> filtered = new LinkedList<IRemoteObject>();
        for (IRemoteObject library : libraries) {
            if (library.getName().equalsIgnoreCase("QTEMP")) continue;
            filtered.add(library);
        }
        return filtered;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof IRemoteObject) {
            IRemoteObject remoteObject = (IRemoteObject)parent;
            if (remoteObject.getType() == IRemoteObject.Type.library) {
                if (!remoteObject.areChildrenLoaded()) {
                    return true;
                }
                return this.workspaceStore.getObjects(remoteObject).size() > 0;
            }
            if (remoteObject.getAttribute() == IRemoteObject.Attribute.sourcefile) {
                if (!remoteObject.areChildrenLoaded()) {
                    return true;
                }
                return this.workspaceStore.getMembers(remoteObject).size() > 0;
            }
        }
        return this.getChildren(parent).length > 0;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}

