/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.explorer.handler.MoveMemberHandler;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

public class QsysViewer
extends TreeViewer {
    private static final String LIBRARY = "library";
    private static final String NEW_MEMBER = "new.member";
    private static final String OLD_MEMBER = "old.member";
    @Inject
    @Named(value="miworkplace.ui.source.id")
    private Long sourceId;
    private static final Long NO_SOURCE_ID = 0L;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IDoubleClickServiceProvider doubleClickServiceProvider;

    @Inject
    public QsysViewer(@Named(value="miworkplace.ui.explorer.viewer.parent") Composite parent) {
        super(parent, 770);
    }

    @PostConstruct
    private void postConstruct(final ESelectionService selectionService) {
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    IConnection connection = null;
                    if (element instanceof IConnection) {
                        connection = (IConnection)element;
                    } else if (element instanceof IRemoteObject) {
                        connection = ((IRemoteObject)element).getConnection();
                    }
                    if (connection != null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("org.eclipse.e4.data", connection);
                        map.put("connection", connection.getName());
                        QsysViewer.this.eventBroker.send("miworkplace/connection/used", map);
                    }
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() == null) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                IDoubleClickExecutor executor = QsysViewer.this.doubleClickServiceProvider.get(element);
                if (executor != null) {
                    executor.execute(element, QsysViewer.this.handlerService, QsysViewer.this.commandService);
                }
            }
        });
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.addDragSupport(2, transferTypes, (DragSourceListener)new DragListener((ISelectionProvider)this));
        DropListener dropListener = new DropListener((Viewer)this);
        ContextInjectionFactory.inject((Object)((Object)dropListener), (IEclipseContext)this.context);
        this.addDropSupport(2, transferTypes, (DropTargetListener)dropListener);
    }

    @PreDestroy
    private void preDestroy() {
    }

    @Inject
    @Optional
    public void notifiedLibrariesLoaded(@UIEventTopic(value="miworkplace/ui/loader/libraries/loaded") Event event) {
        if (event.getProperty("viewerId").equals(this.getSourceId())) {
            String connectionName = event.getProperty("connection").toString();
            IConnection connection = this.connectionManager.get(connectionName);
            Object[] expandedElements = this.getVisibleExpandedElements();
            this.refresh(connection);
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.expandToLevel(object, 1);
                ++n2;
            }
        }
    }

    @Inject
    @Optional
    public void notifiedObjectsLoaded(@UIEventTopic(value="miworkplace/ui/loader/objects/loaded") Event event) {
        String path;
        String connectionName;
        IConnection connection;
        IRemoteObject library;
        Object sourceId = event.getProperty("viewerId");
        if ((this.getSourceId().equals(sourceId) || NO_SOURCE_ID.equals(sourceId)) && (library = this.workspaceStore.get(connection = this.connectionManager.get(connectionName = event.getProperty("connection").toString()), path = event.getProperty("path").toString())) != null) {
            Object[] expandedElements = this.getVisibleExpandedElements();
            this.refresh(library);
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.expandToLevel(object, 1);
                ++n2;
            }
        }
    }

    @Inject
    @Optional
    public void notifiedMembersLoaded(@UIEventTopic(value="miworkplace/ui/loader/member/loaded") Event event) {
        String path;
        String connectionName;
        IConnection connection;
        IRemoteObject sourceFile;
        if (event.getProperty("viewerId").equals(this.getSourceId()) && (sourceFile = this.workspaceStore.get(connection = this.connectionManager.get(connectionName = event.getProperty("connection").toString()), path = event.getProperty("path").toString())) != null) {
            Object[] expandedElements = this.getVisibleExpandedElements();
            this.refresh(sourceFile);
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.setExpandedState(object, true);
                this.expandToLevel(object, 1);
                ++n2;
            }
        }
    }

    @Inject
    @Optional
    public void notifiedMemberMoved(@UIEventTopic(value="miworkplace/member/moved") Event event) {
        IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
        IRemoteObject oldMember = (IRemoteObject)event.getProperty(OLD_MEMBER);
        this.remove(oldMember);
        IRemoteObject sourceFile = this.workspaceStore.get(connection, event.getProperty("dest.source.file.path").toString());
        if (sourceFile != null) {
            Object[] expandedElements = this.getVisibleExpandedElements();
            this.refresh();
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.expandToLevel(object, 0);
                ++n2;
            }
        }
    }

    @Inject
    @Optional
    public void notifiedObjectUpdated(@UIEventTopic(value="miworkplace/object/updated") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        this.refresh(object);
    }

    @Inject
    @Optional
    public void notifiedMemberUpdated(@UIEventTopic(value="miworkplace/member/updated") Event event) {
        SourceMember member = (SourceMember)event.getProperty("org.eclipse.e4.data");
        this.refresh(member);
    }

    @Inject
    @Optional
    public void notifiedObjectRenamed(@UIEventTopic(value="miworkplace/object/renamed") Event event) {
        IRemoteObject oldObject = (IRemoteObject)event.getProperty("old.object");
        IRemoteObject renamedObject = (IRemoteObject)event.getProperty("new.object");
        IRemoteObject library = (IRemoteObject)event.getProperty(LIBRARY);
        this.remove(oldObject);
        if (this.getExpandedState(library)) {
            this.refresh(library, true);
            this.reveal(renamedObject);
        } else {
            this.refresh(library, false);
        }
    }

    @Inject
    @Optional
    public void notifiedMemberCreated(@UIEventTopic(value="miworkplace/member/created") Event event) {
        IRemoteObject file = (IRemoteObject)event.getProperty("file");
        if (this.getExpandedState(file)) {
            this.refresh(file, true);
        } else {
            this.refresh(file, false);
        }
    }

    @Inject
    @Optional
    public void notifiedMemberDeleted(@UIEventTopic(value="miworkplace/member/deleted") Event event) {
        IRemoteObject member = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        this.remove(member);
    }

    @Inject
    @Optional
    public void notifiedMemberRenamed(@UIEventTopic(value="miworkplace/member/renamed") Event event) {
        IRemoteObject oldMember = (IRemoteObject)event.getProperty(OLD_MEMBER);
        this.remove(oldMember);
        SourceMember newMember = (SourceMember)event.getProperty(NEW_MEMBER);
        SourceFile file = this.workspaceStore.getSourceFile(newMember.getConnection(), newMember);
        if (this.getExpandedState(file)) {
            this.refresh(file, true);
            this.reveal(newMember);
        } else {
            this.refresh(file, false);
        }
    }

    @Inject
    @Optional
    public void notifiedObjectCreated(@UIEventTopic(value="miworkplace/object/created") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        if (object.getType() != IRemoteObject.Type.library) {
            IRemoteObject library = this.workspaceStore.getLibrary(object);
            if (this.getExpandedState(library)) {
                this.refresh(library, true);
                this.expandToLevel(object, 0);
            } else {
                this.refresh(library, false);
            }
        }
    }

    @Inject
    @Optional
    public void notifiedObjectDeleted(@UIEventTopic(value="miworkplace/object/deleted") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        this.remove(object);
    }

    @Inject
    @Optional
    public void notifiedCollapse(@UIEventTopic(value="miworkplace/ui/explorer/collapse") Event event) {
        this.collapseAll();
        this.refresh();
    }

    @Inject
    @Optional
    public void notifiedLibraryRemoved(@UIEventTopic(value="miworkplace/connection/listed/removed") Event event) {
        if (event.containsProperty(LIBRARY) && event.getProperty(LIBRARY) != null) {
            IRemoteObject library = (IRemoteObject)event.getProperty(LIBRARY);
            this.remove(library);
        }
    }

    private Long getSourceId() {
        return this.sourceId;
    }

    class DragListener
    extends DragSourceAdapter {
        private final ISelectionProvider selectionProvider;

        public DragListener(ISelectionProvider selectionProvider) {
            this.selectionProvider = selectionProvider;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            event.doit = selection.isEmpty() ? false : selection.getFirstElement() instanceof SourceMember;
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                transfer.setSelection((ISelection)selection);
                transfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
            }
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        @Inject
        private IObjectPropertiesStore propertiesStore;
        @Inject
        private IWorkspaceStore workspaceStore;
        @Inject
        private Shell shell;
        @Inject
        private IEclipseContext context;

        public DropListener(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return this.getCurrentLocation() == 3 && target instanceof IRemoteObject && LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (((IRemoteObject)target).getType() == IRemoteObject.Type.file || target instanceof SourceMember);
        }

        public boolean performDrop(Object data) {
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
            SourceFile targetSourceFile = null;
            List<SourceMember> members = this.getSourceMembers(selection);
            IRemoteObject target = (IRemoteObject)this.getCurrentTarget();
            if (target instanceof SourceMember) {
                SourceMember member = (SourceMember)target;
                targetSourceFile = this.workspaceStore.getSourceFile(member.getConnection(), member);
            } else if (target.getType() == IRemoteObject.Type.file) {
                Map properties = this.propertiesStore.get(target);
                Object attribute = properties.get(ObjectProperty.attribute);
                if (attribute == null) {
                    properties = this.propertiesStore.get(target, true);
                    attribute = properties.get(ObjectProperty.attribute);
                }
                if (IRemoteObject.Attribute.sourcefile.equals(attribute)) {
                    targetSourceFile = target;
                }
            }
            if (targetSourceFile == null) {
                return false;
            }
            QSYSObjectPathName destPath = new QSYSObjectPathName(targetSourceFile.getPath());
            String destination = destPath.getLibraryName() + "/" + destPath.getObjectName();
            MoveMemberHandler handler = (MoveMemberHandler)ContextInjectionFactory.make(MoveMemberHandler.class, (IEclipseContext)this.context);
            handler.move(this.shell, members, members.get(0).getConnection(), destination);
            this.getViewer().refresh();
            return true;
        }

        private List<SourceMember> getSourceMembers(IStructuredSelection selection) {
            LinkedList<SourceMember> members = new LinkedList<SourceMember>();
            for (Object selectedElement : selection) {
                if (!(selectedElement instanceof SourceMember)) continue;
                members.add((SourceMember)selectedElement);
            }
            return members;
        }
    }
}

