/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IContentTypeRegistry;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenWithMenuContribution {
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        Object selection = selectionService.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IRemoteObject object = (IRemoteObject)((IStructuredSelection)selection).getFirstElement();
        if (!(object instanceof SourceMember)) {
            return;
        }
        SourceMember member = (SourceMember)object;
        List matchedContentTypes = this.contentTypeRegistry.getContentType((IRemoteObject)member);
        LinkedList contentTypes = new LinkedList(matchedContentTypes);
        Collections.sort(contentTypes, new Comparator<ContentType>(){

            @Override
            public int compare(ContentType ct1, ContentType ct2) {
                return ct1.getName().compareTo(ct2.getName());
            }
        });
        if (contentTypes.isEmpty()) {
            MDirectMenuItem item = this.createNoMappingMenuItem();
            items.add((MMenuElement)item);
        } else {
            for (ContentType contentType : contentTypes) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                MCommand command = this.getCommandInstance(contentType.getCommandId());
                dynamicItem.setLabel(contentType.getName() + " Editor");
                dynamicItem.setCommand(command);
                dynamicItem.getPersistedState().put("contentType", contentType.getId());
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MDirectMenuItem createNoMappingMenuItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.ui_explorer_noeditor);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }
}

